var panel = new Panel
var panelScreen = panel.screen
var freeEdges = {"top": true, "bottom": true, "left": true, "right": true}

for (i = 0; i < panelIds.length; ++i) {
    var tmpPanel = panelById(panelIds[i])
    if (tmpPanel.screen == panelScreen) {
        // Ignore the new panel
        if (tmpPanel.id != panel.id) {
            freeEdges[tmpPanel.location] = false;
        }
    }
}

if (freeEdges["top"] == true) {
    panel.location = "top";
} else if (freeEdges["bottom"] == true) {
    panel.location = "bottom";
} else if (freeEdges["left"] == true) {
    panel.location = "left";
} else if (freeEdges["right"] == true) {
    panel.location = "right";
} else {
    // There is no free edge, so leave the default value
    panel.location = "top";
}

panel.height = gridUnit * 1.7

var spacer1 = panel.addWidget("org.kde.plasma.panelspacer")
spacer1.writeConfig("expanding", "false")
spacer1.writeConfig("length", "10")

var kicker = panel.addWidget("org.kde.plasma.kicker")
kicker.writeConfig("customButtonImage", "/usr/share/pixmaps/ubuntustudio-logo-menu.png")
kicker.writeConfig("showAppsByName", "true")
kicker.writeConfig("showIconsRootLevel", "true")
kicker.currentConfigGroup = ["Shortcuts"]
kicker.writeConfig("global", "Alt+F1")

var windowtitle = panel.addWidget("org.kde.windowtitle")
windowtitle.currentConfigGroup = ["Appearance"]
windowtitle.writeConfig("activityIcon", "false")
windowtitle.writeConfig("altTxt", "Ubuntu Studio")
windowtitle.writeConfig("customIcon", "/usr/share/pixmaps/ubuntustudio-logo-menu.png")
windowtitle.writeConfig("elidePos", "2")
windowtitle.writeConfig("fixedLength", "190")
windowtitle.writeConfig("isBold", "true")
windowtitle.writeConfig("lengthKind", "1")
windowtitle.writeConfig("midSpace", "10")
windowtitle.writeConfig("visible", "false")

var spacer2 = panel.addWidget("org.kde.plasma.panelspacer")
spacer2.writeConfig("expanding", "false")
spacer2.writeConfig("length", "10")

//panel.addWidget("org.kde.plasma.showActivityManager")

panel.addWidget("org.kde.plasma.appmenu")

var spacer3 = panel.addWidget("org.kde.plasma.panelspacer")
spacer3.writeConfig("expanding", "true")

/* Next up is determining whether to add the Input Method Panel
 * widget to the panel or not. This is done based on whether
 * the system locale's language id is a member of the following
 * white list of languages which are known to pull in one of
 * our supported IME backends when chosen during installation
 * of common distributions. */

var langIds = ["as",    // Assamese
               "bn",    // Bengali
               "bo",    // Tibetan
               "brx",   // Bodo
               "doi",   // Dogri
               "gu",    // Gujarati
               "hi",    // Hindi
               "ja",    // Japanese
               "kn",    // Kannada
               "ko",    // Korean
               "kok",   // Konkani
               "ks",    // Kashmiri
               "lep",   // Lepcha
               "mai",   // Maithili
               "ml",    // Malayalam
               "mni",   // Manipuri
               "mr",    // Marathi
               "ne",    // Nepali
               "or",    // Odia
               "pa",    // Punjabi
               "sa",    // Sanskrit
               "sat",   // Santali
               "sd",    // Sindhi
               "si",    // Sinhala
               "ta",    // Tamil
               "te",    // Telugu
               "th",    // Thai
               "ur",    // Urdu
               "vi",    // Vietnamese
               "zh_CN", // Simplified Chinese
               "zh_TW"] // Traditional Chinese

if (langIds.indexOf(languageId) != -1) {
    panel.addWidget("org.kde.plasma.kimpanel");
}

panel.addWidget("org.kde.plasma.systemtray")
panel.addWidget("org.kde.plasma.digitalclock")
panel.addWidget("org.kde.plasma.minimizeall")

var spacer3 = panel.addWidget("org.kde.plasma.panelspacer")
spacer3.writeConfig("expanding", "false")
spacer3.writeConfig("length", "10")
