# Kokkos only defines the variables if the backends are ON
# Define aux variables that exist as on/off
MACRO(CHECK_KOKKOS_BACKEND BE)
  IF (Kokkos_ENABLE_${BE})
    SET(KOKKOS_ENABLE_${BE} ON)
  ELSE()
    SET(KOKKOS_ENABLE_${BE} OFF)
  ENDIF()
  SET(KOKKOSKERNELS_INST_EXECSPACE_${BE}_DEFAULT ${KOKKOS_ENABLE_${BE}})
ENDMACRO(CHECK_KOKKOS_BACKEND)

CHECK_KOKKOS_BACKEND(SERIAL)
CHECK_KOKKOS_BACKEND(THREADS)
CHECK_KOKKOS_BACKEND(OPENMP)
CHECK_KOKKOS_BACKEND(OPENMPTARGET)
CHECK_KOKKOS_BACKEND(CUDA)
CHECK_KOKKOS_BACKEND(HIP)
CHECK_KOKKOS_BACKEND(SYCL)
