// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Definitions for streaming encryption using AES-GCM
// with HKDF as key derivation function.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v3.21.12
// source: aes_gcm_hkdf_streaming.proto

package aes_gcm_hkdf_streaming_go_proto

import (
	common_go_proto "github.com/tink-crypto/tink-go/v2/proto/common_go_proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type AesGcmHkdfStreamingParams struct {
	state                 protoimpl.MessageState   `protogen:"open.v1"`
	CiphertextSegmentSize uint32                   `protobuf:"varint,1,opt,name=ciphertext_segment_size,json=ciphertextSegmentSize,proto3" json:"ciphertext_segment_size,omitempty"`
	DerivedKeySize        uint32                   `protobuf:"varint,2,opt,name=derived_key_size,json=derivedKeySize,proto3" json:"derived_key_size,omitempty"` // size of AES-GCM keys derived for each segment
	HkdfHashType          common_go_proto.HashType `protobuf:"varint,3,opt,name=hkdf_hash_type,json=hkdfHashType,proto3,enum=google.crypto.tink.HashType" json:"hkdf_hash_type,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *AesGcmHkdfStreamingParams) Reset() {
	*x = AesGcmHkdfStreamingParams{}
	mi := &file_aes_gcm_hkdf_streaming_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AesGcmHkdfStreamingParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AesGcmHkdfStreamingParams) ProtoMessage() {}

func (x *AesGcmHkdfStreamingParams) ProtoReflect() protoreflect.Message {
	mi := &file_aes_gcm_hkdf_streaming_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AesGcmHkdfStreamingParams.ProtoReflect.Descriptor instead.
func (*AesGcmHkdfStreamingParams) Descriptor() ([]byte, []int) {
	return file_aes_gcm_hkdf_streaming_proto_rawDescGZIP(), []int{0}
}

func (x *AesGcmHkdfStreamingParams) GetCiphertextSegmentSize() uint32 {
	if x != nil {
		return x.CiphertextSegmentSize
	}
	return 0
}

func (x *AesGcmHkdfStreamingParams) GetDerivedKeySize() uint32 {
	if x != nil {
		return x.DerivedKeySize
	}
	return 0
}

func (x *AesGcmHkdfStreamingParams) GetHkdfHashType() common_go_proto.HashType {
	if x != nil {
		return x.HkdfHashType
	}
	return common_go_proto.HashType(0)
}

type AesGcmHkdfStreamingKeyFormat struct {
	state         protoimpl.MessageState     `protogen:"open.v1"`
	Version       uint32                     `protobuf:"varint,3,opt,name=version,proto3" json:"version,omitempty"`
	Params        *AesGcmHkdfStreamingParams `protobuf:"bytes,1,opt,name=params,proto3" json:"params,omitempty"`
	KeySize       uint32                     `protobuf:"varint,2,opt,name=key_size,json=keySize,proto3" json:"key_size,omitempty"` // size of the main key (aka. "ikm", input key material)
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AesGcmHkdfStreamingKeyFormat) Reset() {
	*x = AesGcmHkdfStreamingKeyFormat{}
	mi := &file_aes_gcm_hkdf_streaming_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AesGcmHkdfStreamingKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AesGcmHkdfStreamingKeyFormat) ProtoMessage() {}

func (x *AesGcmHkdfStreamingKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_aes_gcm_hkdf_streaming_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AesGcmHkdfStreamingKeyFormat.ProtoReflect.Descriptor instead.
func (*AesGcmHkdfStreamingKeyFormat) Descriptor() ([]byte, []int) {
	return file_aes_gcm_hkdf_streaming_proto_rawDescGZIP(), []int{1}
}

func (x *AesGcmHkdfStreamingKeyFormat) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *AesGcmHkdfStreamingKeyFormat) GetParams() *AesGcmHkdfStreamingParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *AesGcmHkdfStreamingKeyFormat) GetKeySize() uint32 {
	if x != nil {
		return x.KeySize
	}
	return 0
}

// key_type: type.googleapis.com/google.crypto.tink.AesGcmHkdfStreamingKey
type AesGcmHkdfStreamingKey struct {
	state         protoimpl.MessageState     `protogen:"open.v1"`
	Version       uint32                     `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Params        *AesGcmHkdfStreamingParams `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	KeyValue      []byte                     `protobuf:"bytes,3,opt,name=key_value,json=keyValue,proto3" json:"key_value,omitempty"` // Placeholder for ctype and debug_redact.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AesGcmHkdfStreamingKey) Reset() {
	*x = AesGcmHkdfStreamingKey{}
	mi := &file_aes_gcm_hkdf_streaming_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AesGcmHkdfStreamingKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AesGcmHkdfStreamingKey) ProtoMessage() {}

func (x *AesGcmHkdfStreamingKey) ProtoReflect() protoreflect.Message {
	mi := &file_aes_gcm_hkdf_streaming_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AesGcmHkdfStreamingKey.ProtoReflect.Descriptor instead.
func (*AesGcmHkdfStreamingKey) Descriptor() ([]byte, []int) {
	return file_aes_gcm_hkdf_streaming_proto_rawDescGZIP(), []int{2}
}

func (x *AesGcmHkdfStreamingKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *AesGcmHkdfStreamingKey) GetParams() *AesGcmHkdfStreamingParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *AesGcmHkdfStreamingKey) GetKeyValue() []byte {
	if x != nil {
		return x.KeyValue
	}
	return nil
}

var File_aes_gcm_hkdf_streaming_proto protoreflect.FileDescriptor

const file_aes_gcm_hkdf_streaming_proto_rawDesc = "" +
	"\n" +
	"\x1caes_gcm_hkdf_streaming.proto\x12\x12google.crypto.tink\x1a\x12proto/common.proto\"\xc1\x01\n" +
	"\x19AesGcmHkdfStreamingParams\x126\n" +
	"\x17ciphertext_segment_size\x18\x01 \x01(\rR\x15ciphertextSegmentSize\x12(\n" +
	"\x10derived_key_size\x18\x02 \x01(\rR\x0ederivedKeySize\x12B\n" +
	"\x0ehkdf_hash_type\x18\x03 \x01(\x0e2\x1c.google.crypto.tink.HashTypeR\fhkdfHashType\"\x9a\x01\n" +
	"\x1cAesGcmHkdfStreamingKeyFormat\x12\x18\n" +
	"\aversion\x18\x03 \x01(\rR\aversion\x12E\n" +
	"\x06params\x18\x01 \x01(\v2-.google.crypto.tink.AesGcmHkdfStreamingParamsR\x06params\x12\x19\n" +
	"\bkey_size\x18\x02 \x01(\rR\akeySize\"\x96\x01\n" +
	"\x16AesGcmHkdfStreamingKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12E\n" +
	"\x06params\x18\x02 \x01(\v2-.google.crypto.tink.AesGcmHkdfStreamingParamsR\x06params\x12\x1b\n" +
	"\tkey_value\x18\x03 \x01(\fR\bkeyValueBi\n" +
	"\x1ccom.google.crypto.tink.protoP\x01ZGgithub.com/tink-crypto/tink-go/v2/proto/aes_gcm_hkdf_streaming_go_protob\x06proto3"

var (
	file_aes_gcm_hkdf_streaming_proto_rawDescOnce sync.Once
	file_aes_gcm_hkdf_streaming_proto_rawDescData []byte
)

func file_aes_gcm_hkdf_streaming_proto_rawDescGZIP() []byte {
	file_aes_gcm_hkdf_streaming_proto_rawDescOnce.Do(func() {
		file_aes_gcm_hkdf_streaming_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_aes_gcm_hkdf_streaming_proto_rawDesc), len(file_aes_gcm_hkdf_streaming_proto_rawDesc)))
	})
	return file_aes_gcm_hkdf_streaming_proto_rawDescData
}

var file_aes_gcm_hkdf_streaming_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_aes_gcm_hkdf_streaming_proto_goTypes = []any{
	(*AesGcmHkdfStreamingParams)(nil),    // 0: google.crypto.tink.AesGcmHkdfStreamingParams
	(*AesGcmHkdfStreamingKeyFormat)(nil), // 1: google.crypto.tink.AesGcmHkdfStreamingKeyFormat
	(*AesGcmHkdfStreamingKey)(nil),       // 2: google.crypto.tink.AesGcmHkdfStreamingKey
	(common_go_proto.HashType)(0),        // 3: google.crypto.tink.HashType
}
var file_aes_gcm_hkdf_streaming_proto_depIdxs = []int32{
	3, // 0: google.crypto.tink.AesGcmHkdfStreamingParams.hkdf_hash_type:type_name -> google.crypto.tink.HashType
	0, // 1: google.crypto.tink.AesGcmHkdfStreamingKeyFormat.params:type_name -> google.crypto.tink.AesGcmHkdfStreamingParams
	0, // 2: google.crypto.tink.AesGcmHkdfStreamingKey.params:type_name -> google.crypto.tink.AesGcmHkdfStreamingParams
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_aes_gcm_hkdf_streaming_proto_init() }
func file_aes_gcm_hkdf_streaming_proto_init() {
	if File_aes_gcm_hkdf_streaming_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_aes_gcm_hkdf_streaming_proto_rawDesc), len(file_aes_gcm_hkdf_streaming_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_aes_gcm_hkdf_streaming_proto_goTypes,
		DependencyIndexes: file_aes_gcm_hkdf_streaming_proto_depIdxs,
		MessageInfos:      file_aes_gcm_hkdf_streaming_proto_msgTypes,
	}.Build()
	File_aes_gcm_hkdf_streaming_proto = out.File
	file_aes_gcm_hkdf_streaming_proto_goTypes = nil
	file_aes_gcm_hkdf_streaming_proto_depIdxs = nil
}
