/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineException;
import com.paterva.maltego.automation.MachineRuntimeListener;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import java.util.Collection;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public abstract class MachineManager {
    public static MachineManager getDefault() {
        MachineManager manager = (MachineManager)Lookup.getDefault().lookup(MachineManager.class);
        if (manager == null) {
            manager = new TrivialMachineManager();
        }
        return manager;
    }

    public void start(DataObject target, MachineDescriptor machine, Payload payload, int iterationCount, boolean shutdownWhenComplete) throws MachineException {
        this.start(target, machine, payload, true, iterationCount, shutdownWhenComplete);
    }

    public void start(DataObject target, MachineDescriptor machine) throws MachineException {
        this.start(target, machine, true);
    }

    public abstract void start(DataObject var1, MachineDescriptor var2, Payload var3, boolean var4, int var5, boolean var6) throws MachineException;

    public abstract void start(DataObject var1, MachineDescriptor var2, Payload var3, boolean var4) throws MachineException;

    public abstract void start(DataObject var1, MachineDescriptor var2, boolean var3) throws MachineException;

    public abstract void suspend(DataObject var1, MachineDescriptor var2);

    public abstract void resume(DataObject var1, MachineDescriptor var2);

    public abstract void addMachineListener(MachineRuntimeListener var1);

    public abstract void removeMachineListener(MachineRuntimeListener var1);

    public abstract void handleEvent(DataObject var1, Object var2, GraphID var3, Collection<? extends MaltegoEntity> var4);

    public abstract void handleEvent(DataObject var1, Object var2);

    public abstract void stop(DataObject var1, MachineDescriptor var2);

    public abstract void stopAll(DataObject var1);

    public abstract void stopAll();

    private static class TrivialMachineManager
    extends MachineManager {
        private TrivialMachineManager() {
        }

        @Override
        public void start(DataObject target, MachineDescriptor machine, Payload payload, boolean validate, int interationCount, boolean shutdownWhenComplete) throws MachineException {
        }

        @Override
        public void start(DataObject target, MachineDescriptor machine, Payload payload, boolean validate) {
        }

        @Override
        public void start(DataObject target, MachineDescriptor machine, boolean validate) {
        }

        @Override
        public void handleEvent(DataObject target, Object eventName, GraphID graphID, Collection<? extends MaltegoEntity> entities) {
        }

        @Override
        public void stop(DataObject target, MachineDescriptor machine) {
        }

        @Override
        public void stopAll(DataObject target) {
        }

        @Override
        public void stopAll() {
        }

        @Override
        public void suspend(DataObject target, MachineDescriptor machine) {
        }

        @Override
        public void handleEvent(DataObject target, Object eventName) {
        }

        @Override
        public void resume(DataObject target, MachineDescriptor machine) {
        }

        @Override
        public void addMachineListener(MachineRuntimeListener listener) {
        }

        @Override
        public void removeMachineListener(MachineRuntimeListener listener) {
        }
    }
}

