/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene;

import com.pinkmatter.pandora.PandoraConnection;
import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraSchema;
import com.pinkmatter.pandora.PandoraSearch;
import com.pinkmatter.pandora.PandoraStore;
import com.pinkmatter.pandora.lucene.LuceneConnection;
import com.pinkmatter.pandora.lucene.LuceneSchema;
import com.pinkmatter.pandora.lucene.LuceneSearcher;
import com.pinkmatter.pandora.lucene.LuceneStore;
import java.io.File;

public class PandoraLuceneFactory {
    public PandoraConnection createInMemoryConnection() throws PandoraException {
        return LuceneConnection.createInMemoryConnection();
    }

    public PandoraConnection createFileConnection(File indexPath) throws PandoraException {
        return LuceneConnection.createFileConnection(indexPath);
    }

    public PandoraSearch createSearcher(PandoraConnection cn, boolean autoRefresh) {
        if (!(cn instanceof LuceneConnection)) {
            throw new IllegalArgumentException("Connection must be of type LuceneConnection.");
        }
        return new LuceneSearcher((LuceneConnection)cn, autoRefresh);
    }

    public PandoraStore createStore(PandoraConnection cn, boolean autoCommit) {
        return this.createStore(cn, autoCommit, true);
    }

    public PandoraStore createStore(PandoraConnection cn, boolean autoCommit, boolean autoKey) {
        if (!(cn instanceof LuceneConnection)) {
            throw new IllegalArgumentException("Connection must be of type LuceneConnection.");
        }
        return new LuceneStore((LuceneConnection)cn, autoCommit, autoKey);
    }

    public PandoraSchema createSchema(PandoraConnection cn, boolean autoRefresh) {
        if (!(cn instanceof LuceneConnection)) {
            throw new IllegalArgumentException("Connection must be of type LuceneConnection.");
        }
        return new LuceneSchema((LuceneConnection)cn, autoRefresh);
    }
}

