/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.ui;

import com.paterva.maltego.collab.ui.ConnectBackgroundWorker;
import com.paterva.maltego.collab.ui.ShareNewGraphForm;
import com.paterva.maltego.collab.ui.SharedGraphBackgroundWorkerListener;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;

class ShareGraphFormContainer {
    private final ShareNewGraphForm _form;
    private final JButton _connectButton;
    private final JButton _cancelButton;
    private final Dialog[] _dialogHolder = new Dialog[1];

    ShareGraphFormContainer(GraphDataObject gdo) {
        this._form = new ShareNewGraphForm();
        this._connectButton = new JButton("Connect");
        this._cancelButton = new JButton("Cancel");
        if (gdo != null) {
            this._form.setWorker(new ConnectBackgroundWorker(gdo));
        } else {
            this._form.setWorker(new ConnectBackgroundWorker());
        }
        this._form.addChangeListener(new PropertyChangeListenerImpl());
        this._form.validateFormData();
    }

    ShareGraphFormContainer() {
        this(null);
    }

    ShareNewGraphForm getForm() {
        return this._form;
    }

    JButton getConnectButton() {
        return this._connectButton;
    }

    JButton getCancelButton() {
        return this._cancelButton;
    }

    Dialog[] getDialogHolder() {
        return this._dialogHolder;
    }

    void addBackgroundWorkerListener(SharedGraphBackgroundWorkerListener listener) {
        this._form.addBackgroundWorkerListener(listener);
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private PropertyChangeListenerImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("ERROR_STATE")) {
                boolean isInError = (Boolean)evt.getNewValue();
                ShareGraphFormContainer.this._connectButton.setEnabled(!isInError);
            }
        }
    }
}

