/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab;

import java.util.HashMap;
import java.util.Map;

public class Participant {
    public static final String CLIENT_VERSION = "v";
    public static final String TAGLINE = "tag";
    public static final String CLIENT_PRODUCT = "prod";
    private final String _id;
    private final String _name;
    private final boolean _me;
    private String _userID;
    private String _roomID;
    private Map<String, String> _properties;

    public Participant(String id, String name) {
        this(id, name, false);
    }

    public Participant(String id, String name, boolean me) {
        this._id = id;
        this._name = name;
        this._me = me;
        String[] split = id.split("/");
        if (split.length >= 2) {
            this._roomID = split[0];
            this._userID = split[1];
        }
        this._properties = new HashMap<String, String>(3);
    }

    public String getID() {
        return this._id;
    }

    public String getRoomID() {
        if (this._roomID != null) {
            return this._roomID;
        }
        return this._id;
    }

    public String getUserID() {
        if (this._userID != null) {
            return this._userID;
        }
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public boolean isMe() {
        return this._me;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Participant other = (Participant)obj;
        return !(this._id == null ? other._id != null : !this._id.equals(other._id));
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + (this._id != null ? this._id.hashCode() : 0);
        return hash;
    }

    public void putProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.putProperty(entry.getKey(), entry.getValue());
        }
    }

    public void putProperty(String name, String value) {
        this._properties.put(name, value);
    }

    public Map<String, String> getProperties() {
        return this._properties;
    }

    public String getProperty(String key, String defaultValue) {
        String value = this._properties.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getStatusText() {
        return this.getProperty(TAGLINE, null);
    }

    public void setStatusText(String statusText) {
        this.putProperty(TAGLINE, statusText);
    }

    public String getClientVersion() {
        return this.getProperty(CLIENT_VERSION, null);
    }

    public void setClientVersion(String clientVersion) {
        this.putProperty(CLIENT_VERSION, clientVersion);
    }

    public String getProductName() {
        return this.getProperty(CLIENT_PRODUCT, "Maltego");
    }

    public void setProductName(String clientVersion) {
        this.putProperty(CLIENT_PRODUCT, clientVersion);
    }
}

