/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.api;

import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.protocol.api.proxy.DefaultHttpProxy;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransformServerSeedInfo {
    private static final String PROTOCOL_VERSION_HEADER_KEY = "maltego-protocol-version";
    private static final Logger LOG = Logger.getLogger(TransformServerSeedInfo.class.getName());

    public ProtocolVersion getProtocolVersion(String source, boolean httpsOnly, String maltegoApiKey, List<Exception> errors) {
        try {
            DefaultHttpProxy proxy = new DefaultHttpProxy(source);
            Map<String, String> serverOptions = proxy.getSeedInfo(false, maltegoApiKey);
            String configuredProtocolVersion = null;
            for (Map.Entry<String, String> option : serverOptions.entrySet()) {
                if (option == null || option.getKey() == null || !option.getKey().equalsIgnoreCase(PROTOCOL_VERSION_HEADER_KEY)) continue;
                configuredProtocolVersion = option.getValue();
                break;
            }
            if (configuredProtocolVersion == null) {
                return ProtocolVersion.V2_0;
            }
            return ProtocolVersion.get(configuredProtocolVersion);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to retrieve the protocol version from url {0} with exception message: {1}", new Object[]{source, ex.getMessage()});
            errors.add(ex);
            return ProtocolVersion.V2_0;
        }
    }
}

