/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chatapi.msg;

import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.msg.ChatLinkTranslator;
import com.paterva.maltego.chatapi.msg.ChatLinkTranslators;
import com.paterva.maltego.util.output.MessageChunk;
import com.paterva.maltego.util.output.MessageLinkListener;
import com.paterva.maltego.util.output.OutputMessage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.util.Lookup;

public class ChatMessageTranslator {
    private static ChatMessageTranslator _default;
    private static final String SPECIAL = "|$()";
    private static final String NOT_SPECIAL = "[^|$()]";
    private static final String ESCAPED_CHAR = "(?:\\$.)";
    private static final String ESAPED_AND_OTHER = "((?:[^|$()]|(?:\\$.))++)";
    private static final Pattern LNK_PATTERN;

    public static synchronized ChatMessageTranslator getDefault() {
        if (_default == null && (_default = (ChatMessageTranslator)Lookup.getDefault().lookup(ChatMessageTranslator.class)) == null) {
            _default = new ChatMessageTranslator();
        }
        return _default;
    }

    public String translate(ChatRoom chatRoom, OutputMessage message) {
        StringBuilder sb = new StringBuilder();
        for (MessageChunk chunk : message.getChunks()) {
            ChatLinkTranslator translator;
            String text = chunk.getText();
            MessageLinkListener linkListener = chunk.getLinkListener();
            boolean onlyText = true;
            if (linkListener != null && (translator = ChatLinkTranslators.get(linkListener.getTranslatorID())) != null) {
                onlyText = false;
                sb.append("$lnk(").append(this.escape(text)).append("|");
                sb.append(this.escape(translator.getID())).append("|");
                sb.append(this.escape(translator.translate(chatRoom, linkListener)));
                sb.append(")");
            }
            if (!onlyText) continue;
            sb.append(text);
        }
        return sb.toString();
    }

    public OutputMessage translate(ChatRoom chatRoom, String message) {
        int start = 0;
        Matcher matcher = LNK_PATTERN.matcher(message);
        OutputMessage msg = new OutputMessage();
        while (matcher.find()) {
            String pre = message.substring(start, matcher.start());
            msg.addChunk(new MessageChunk(pre));
            String listenerText = this.unescape(matcher.group(1));
            String translatorID = this.unescape(matcher.group(2));
            String encodedListener = this.unescape(matcher.group(3));
            MessageLinkListener listener = this.translate(chatRoom, translatorID, encodedListener);
            if (listener != null) {
                msg.addChunk(new MessageChunk(listenerText, listener));
            } else {
                msg.addChunk(new MessageChunk(matcher.group(0)));
            }
            start = matcher.end();
        }
        String post = message.substring(start, message.length());
        msg.addChunk(new MessageChunk(post));
        return msg;
    }

    private MessageLinkListener translate(ChatRoom chatRoom, String translatorID, String encodedListener) {
        MessageLinkListener listener = null;
        try {
            ChatLinkTranslator translator = ChatLinkTranslators.get(translatorID);
            if (translator != null) {
                listener = translator.translate(chatRoom, encodedListener);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return listener;
    }

    private String escape(String text) {
        return text.replace("$", "$$").replace("|", "$|").replace("(", "$(").replace(")", "$)");
    }

    private String unescape(String text) {
        return text.replace("$$", "$").replace("$|", "|").replace("$(", "(").replace("$)", ")");
    }

    static {
        LNK_PATTERN = Pattern.compile("^\\$lnk\\(((?:[^|$()]|(?:\\$.))++)\\|((?:[^|$()]|(?:\\$.))++)\\|((?:[^|$()]|(?:\\$.))++)\\)$");
    }
}

