/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chatapi.msg;

import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.msg.ChatMessageHandler;
import com.paterva.maltego.chatapi.msg.ChatMessageHandlerRegistry;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.chatapi.user.User;
import com.paterva.maltego.util.output.OutputMessage;
import java.awt.Color;
import java.util.Collection;
import java.util.Date;
import javax.swing.SwingUtilities;

public class ChatMessagePropagator {
    private ChatMessagePropagator() {
    }

    public static void chatMessage(final ChatRoom chatRoom, final User user, final OutputMessage message, final Date date) {
        ChatMessagePropagator.runInEDT(new Runnable(){

            @Override
            public void run() {
                Collection<ChatMessageHandler> handlers = ChatMessageHandlerRegistry.getDefault().getAll();
                for (ChatMessageHandler handler : handlers) {
                    handler.chatMessage(chatRoom, user, message, date);
                }
            }
        });
    }

    public static void logMessage(final ChatRoom chatRoom, final LogMessageLevel level, final OutputMessage message, final Date date) {
        ChatMessagePropagator.runInEDT(new Runnable(){

            @Override
            public void run() {
                Collection<ChatMessageHandler> handlers = ChatMessageHandlerRegistry.getDefault().getAll();
                for (ChatMessageHandler handler : handlers) {
                    handler.logMessage(chatRoom, level, message, date);
                }
            }
        });
    }

    public static void logMessage(final ChatRoom chatRoom, final LogMessageLevel level, final OutputMessage message, final Color color, final Date date) {
        ChatMessagePropagator.runInEDT(new Runnable(){

            @Override
            public void run() {
                Collection<ChatMessageHandler> handlers = ChatMessageHandlerRegistry.getDefault().getAll();
                for (ChatMessageHandler handler : handlers) {
                    handler.logMessage(chatRoom, level, message, color, date);
                }
            }
        });
    }

    private static void runInEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

