/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chatapi.file;

import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.file.FileOperation;
import com.paterva.maltego.chatapi.file.FileOperationState;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class DefaultFileOperation
implements FileOperation {
    private ChatRoom _chatRoom;
    private String _filename;
    private FileOperationState _state;
    private String _status = "";
    private int _progress = 0;
    private PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

    public DefaultFileOperation(ChatRoom chatRoom, String filename) {
        this._chatRoom = chatRoom;
        this._filename = filename;
    }

    @Override
    public ChatRoom getChatRoom() {
        return this._chatRoom;
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    @Override
    public void setState(FileOperationState state) {
        if (this._state != state) {
            FileOperationState old = this._state;
            this._state = state;
            this.firePropertyChange("stateChanged", (Object)old, (Object)this._state);
        }
    }

    @Override
    public FileOperationState getState() {
        return this._state;
    }

    @Override
    public void setStatus(String status) {
        if (!status.equals(this._status)) {
            String old = this._status;
            this._status = status;
            this.firePropertyChange("statusChanged", old, this._status);
        }
    }

    @Override
    public String getStatus() {
        return this._status;
    }

    @Override
    public void setProgress(int progress) {
        if (this._progress != progress) {
            int old = this._progress;
            this._progress = progress;
            this.firePropertyChange("progressChanged", old, this._progress);
        }
    }

    @Override
    public int getProgress() {
        return this._progress;
    }

    @Override
    public boolean isCancelled() {
        return this._state == FileOperationState.Cancelled;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this._changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

