/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.ball;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainter;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettings;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettingsEvent;
import com.paterva.maltego.view.ball.BallCustomizableView;
import com.paterva.maltego.view.customization.api.CustomizableView;
import com.paterva.maltego.view.customization.api.ViewletToolbarFactory;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class BallPainterToolbarPanel
extends JPanel {
    private final BallCustomizableView _view;
    private final EntityPainter _painter;
    private final GraphID _graphID;
    private PropertyChangeListener _settingsListener;
    private ChangeListener _viewletsListener;

    public BallPainterToolbarPanel(EntityPainter painter, GraphID graphID, BallCustomizableView view) {
        this.setLayout(new BoxLayout(this, 1));
        this._painter = painter;
        this._graphID = graphID;
        this._view = view;
        Dimension d = new Dimension(1, 1);
        this.setMinimumSize(d);
        JToolBar toolbar = ViewletToolbarFactory.getDefault().create((CustomizableView)this._view);
        toolbar.setBorder(new EmptyBorder(0, 0, 0, 0));
        toolbar.setMinimumSize(d);
        toolbar.setOrientation(1);
        toolbar.setMargin(new Insets(0, 0, 0, 0));
        this.add(toolbar);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._settingsListener = new SettingsListener();
        EntityPainterSettings.getDefault().addPropertyChangeListener(this._settingsListener);
        this._viewletsListener = new ViewletsListener();
        this._view.addViewletListener(this._viewletsListener);
    }

    @Override
    public void removeNotify() {
        EntityPainterSettings.getDefault().removePropertyChangeListener(this._settingsListener);
        this._settingsListener = null;
        this._view.removeViewletListener(this._viewletsListener);
        this._viewletsListener = null;
        super.removeNotify();
    }

    private class ViewletsListener
    implements ChangeListener {
        private ViewletsListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            String viewlet = BallPainterToolbarPanel.this._view.getActiveViewlet();
            if ("Main".equals(viewlet)) {
                EntityPainterSettings.getDefault().setEntityPainter(BallPainterToolbarPanel.this._graphID, "Main");
            } else if (!"ListView".equals(viewlet)) {
                EntityPainterSettings.getDefault().setEntityPainter(BallPainterToolbarPanel.this._graphID, "BallView");
            }
        }
    }

    private class SettingsListener
    implements PropertyChangeListener {
        private SettingsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("painterChanged".equals(evt.getPropertyName())) {
                EntityPainterSettingsEvent event = (EntityPainterSettingsEvent)evt.getNewValue();
                if (BallPainterToolbarPanel.this._graphID.equals((Object)event.getGraphID())) {
                    String painterNameAfter = event.getPainterNameAfter();
                    if (!BallPainterToolbarPanel.this._painter.getName().equals(painterNameAfter)) {
                        if ("Main".equals(painterNameAfter)) {
                            BallPainterToolbarPanel.this._view.setActiveViewlet("Main");
                        } else {
                            BallPainterToolbarPanel.this._view.setActiveViewlet(null);
                        }
                    }
                }
            }
        }
    }
}

