/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config.jre.mac;

import com.paterva.maltego.java.config.jre.DetectJavas;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class MacDetectJava
extends DetectJavas {
    private final String[] JVM_PATHS1 = new String[]{"/Library/Java/JavaVirtualMachines/"};
    private final String[] JVM_PATHS2 = new String[]{"/System/Library/Frameworks/JavaVM.framework/Versions/"};
    private final String[] JVM_PATHS3 = new String[]{"/Library/Internet Plug-Ins/JavaAppletPlugin.plugin/"};

    @Override
    protected Set<String> getPathsToTry() {
        Set<String> paths = super.getPathsToTry();
        paths.addAll(this.getExistingSearchPaths());
        this.removeNonJavaHomes(paths);
        this.removeSymLinkDuplicates(paths);
        return paths;
    }

    private Set<String> getExistingSearchPaths() {
        HashSet<String> paths = new HashSet<String>();
        for (String jvmsPath : this.JVM_PATHS1) {
            this.addExistingSearchPaths(jvmsPath, paths, true);
        }
        for (String jvmsPath : this.JVM_PATHS2) {
            this.addExistingSearchPaths(jvmsPath, paths, false);
        }
        for (String jvmPath : this.JVM_PATHS3) {
            this.addSearchPath(new File(jvmPath), paths, true);
        }
        return paths;
    }

    private void addExistingSearchPaths(String jvmsPath, Set<String> paths, boolean contentsSubDir) {
        File jvmsFile = new File(jvmsPath);
        if (jvmsFile.isDirectory()) {
            File[] files;
            for (File jvmPath : files = jvmsFile.listFiles()) {
                this.addSearchPath(jvmPath, paths, contentsSubDir);
            }
        }
    }

    private void addSearchPath(File jvmPath, Set<String> paths, boolean contentsSubDir) {
        File jvmHome;
        if (jvmPath.isDirectory() && (jvmHome = new File(contentsSubDir ? new File(jvmPath, "Contents") : jvmPath, "Home")).isDirectory()) {
            String jvmHomePath = jvmHome.getAbsolutePath();
            System.out.println(jvmPath.getName() + ": " + jvmHomePath);
            paths.add(jvmHomePath);
        }
    }
}

