/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon.appmenu;

import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryPrimary;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntrySecondary;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.CommandButtonLayoutManagerMenuTileLevel2;

public class JRibbonApplicationMenuPopupPanelSecondary
extends JCommandButtonPanel {
    protected static final CommandButtonDisplayState MENU_TILE_LEVEL_2 = new CommandButtonDisplayState("Ribbon application menu tile level 2", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton commandButton) {
            return new CommandButtonLayoutManagerMenuTileLevel2();
        }
    };

    public JRibbonApplicationMenuPopupPanelSecondary(RibbonApplicationMenuEntryPrimary primaryMenuEntry) {
        super(MENU_TILE_LEVEL_2);
        this.setMaxButtonColumns(1);
        int groupCount = primaryMenuEntry.getSecondaryGroupCount();
        for (int i = 0; i < groupCount; ++i) {
            String groupDesc = primaryMenuEntry.getSecondaryGroupTitleAt(i);
            this.addButtonGroup(groupDesc);
            for (RibbonApplicationMenuEntrySecondary menuEntry : primaryMenuEntry.getSecondaryGroupEntries(i)) {
                JCommandMenuButton commandButton = new JCommandMenuButton(menuEntry.getText(), menuEntry.getIcon());
                commandButton.setExtraText(menuEntry.getDescriptionText());
                commandButton.setCommandButtonKind(menuEntry.getEntryKind());
                commandButton.addActionListener(menuEntry.getMainActionListener());
                commandButton.setDisplayState(MENU_TILE_LEVEL_2);
                commandButton.setHorizontalAlignment(10);
                commandButton.setPopupOrientationKind(JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
                commandButton.setEnabled(menuEntry.isEnabled());
                commandButton.setVisible(menuEntry.isVisible());
                commandButton.setPopupCallback(menuEntry.getPopupCallback());
                commandButton.setActionKeyTip(menuEntry.getActionKeyTip());
                commandButton.setPopupKeyTip(menuEntry.getPopupKeyTip());
                if (menuEntry.getDisabledIcon() != null) {
                    commandButton.setDisabledIcon(menuEntry.getDisabledIcon());
                }
                this.addButtonToLastGroup(commandButton);
            }
        }
    }
}

