/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpSocketTimeoutHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResponseHandlerInfo {
    private boolean isResponseHandler = false;
    private boolean isResponseHandlerInvokeOnMessageReceived = false;
    private boolean isResponseHandlerMultithreaded = true;
    private boolean isResponseExeptionHandlerMultithreaded = true;
    private boolean isSocketTimeoutHandler = false;
    private boolean isSocketTimeoutHandlerMultithreaded = true;

    ResponseHandlerInfo(Class clazz) {
        if (clazz == null) {
            return;
        }
        if (IHttpResponseHandler.class.isAssignableFrom(clazz)) {
            this.isResponseHandler = true;
            this.isResponseHandlerMultithreaded = ResponseHandlerInfo.isOnResponseMultithreaded(clazz);
            this.isResponseHandlerInvokeOnMessageReceived = ResponseHandlerInfo.isOnResponseInvokeOnMessageReceived(clazz);
            this.isResponseExeptionHandlerMultithreaded = ResponseHandlerInfo.isOnResponseExceptionMultithreaded(clazz);
        }
        if (IHttpSocketTimeoutHandler.class.isAssignableFrom(clazz)) {
            this.isSocketTimeoutHandler = true;
            this.isSocketTimeoutHandlerMultithreaded = ResponseHandlerInfo.isOnResponseTimeoutMultithreaded(clazz);
        }
    }

    static boolean isOnResponseMultithreaded(Class<IHttpResponseHandler> handlerClass) {
        boolean isMultithreaded = HttpUtils.isHandlerMultithreaded(handlerClass, true);
        return HttpUtils.isMethodMultithreaded(handlerClass, "onResponse", isMultithreaded, IHttpResponse.class);
    }

    static boolean isOnResponseExceptionMultithreaded(Class<IHttpResponseHandler> handlerClass) {
        boolean isMultithreaded = HttpUtils.isHandlerMultithreaded(handlerClass, true);
        return HttpUtils.isMethodMultithreaded(handlerClass, "onException", isMultithreaded, IOException.class);
    }

    static boolean isOnResponseTimeoutMultithreaded(Class<IHttpResponseHandler> handlerClass) {
        boolean isMultithreaded = HttpUtils.isHandlerMultithreaded(handlerClass, true);
        return HttpUtils.isMethodMultithreaded(handlerClass, "onException", isMultithreaded, SocketTimeoutException.class);
    }

    static boolean isOnResponseInvokeOnMessageReceived(Class<IHttpResponseHandler> handlerClass) {
        boolean invokeOnMessageReceived = HttpUtils.isInvokeOnMessageReceived(handlerClass, false);
        return HttpUtils.isInvokeOnMessageReceived(handlerClass, "onResponse", invokeOnMessageReceived, IHttpResponse.class);
    }

    public boolean isResponseHandler() {
        return this.isResponseHandler;
    }

    public boolean isResponseHandlerInvokeOnMessageReceived() {
        return this.isResponseHandlerInvokeOnMessageReceived;
    }

    public boolean isResponseHandlerMultithreaded() {
        return this.isResponseHandlerMultithreaded;
    }

    public boolean isSocketTimeoutHandler() {
        return this.isSocketTimeoutHandler;
    }

    public boolean isResponseExeptionHandlerMultithreaded() {
        return this.isResponseExeptionHandlerMultithreaded;
    }

    public boolean isSocketTimeoutHandlerMultithreaded() {
        return this.isSocketTimeoutHandlerMultithreaded;
    }
}

