/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractBodyParser;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyType;
import org.xlightweb.ComposedByteBuffer;
import org.xlightweb.IHttpHeader;
import org.xlightweb.ProtocolException;

final class FullMessageBodyParser
extends AbstractBodyParser {
    private static final Logger LOG = Logger.getLogger(FullMessageBodyParser.class.getName());
    private final int size;
    private int remaining;

    public FullMessageBodyParser(AbstractHttpConnection httpConnection, IHttpHeader header) throws IOException {
        super(BodyType.FULL_MESSAGE, httpConnection, header);
        this.remaining = this.size = header.getContentLength();
    }

    void doParse(ComposedByteBuffer rawData) throws IOException {
        int available = rawData.available();
        if (available == 0) {
            return;
        }
        if (available < this.remaining) {
            rawData.readByteBufferByLength(available, this);
            this.remaining -= available;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getConnectionId() + "] " + available + " bytes read remaining=" + this.remaining);
            }
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getConnectionId() + "] reading remaining data " + this.remaining);
            }
            rawData.readByteBufferByLength(this.remaining, this);
            this.remaining = 0;
        }
        if (this.remaining == 0) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getConnectionId() + "] complete body received (size=" + this.size + ")");
            }
            this.setComplete();
        } else if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("[" + this.getConnectionId() + "] body data read. wating for more data");
        }
    }

    void onException(IOException ioe, ComposedByteBuffer rawData) {
        if (!this.isComplete()) {
            String msg = "error occured by parsing full message body (expected size: " + this.size + " received size: " + (this.size - this.remaining) + ") ";
            msg = ioe instanceof ClosedChannelException ? msg + "connection disconnected (by peer?)" : msg + ioe.toString();
            this.register(new ProtocolException(msg));
        }
    }

    void onDisconnect() {
        if (!this.isComplete()) {
            this.setPersistent(false);
        }
        super.onDisconnect();
    }
}

