/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

public final class ProtocolVersion
implements Comparable<ProtocolVersion> {
    public static final ProtocolVersion V2_0 = new ProtocolVersion(2, 0);
    public static final ProtocolVersion V3_0 = new ProtocolVersion(3, 0);
    public static final ProtocolVersion V3_1 = new ProtocolVersion(3, 1);
    private int _major;
    private int _minor;

    public int getValue() {
        return this._major * 100 + this._minor;
    }

    public ProtocolVersion(int major, int minor) {
        this._major = major;
        this._minor = minor;
    }

    public static ProtocolVersion get(String version) throws NumberFormatException {
        String[] split = (version = version.trim()).split("\\.");
        if (split.length == 0 || split.length == 1) {
            return new ProtocolVersion(Integer.valueOf(version), 0);
        }
        if (split.length == 2) {
            return new ProtocolVersion(Integer.valueOf(split[0]), Integer.valueOf(split[1]));
        }
        throw new NumberFormatException("Illegal version: " + version);
    }

    public static ProtocolVersion get(String version, ProtocolVersion defaultProtocolVersion) {
        if (version == null || version.isEmpty()) {
            return defaultProtocolVersion;
        }
        return ProtocolVersion.get(version);
    }

    public String toString() {
        return this._major + "." + this._minor;
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + this._major;
        hash = 23 * hash + this._minor;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolVersion other = (ProtocolVersion)obj;
        if (this._major != other._major) {
            return false;
        }
        return this._minor == other._minor;
    }

    @Override
    public int compareTo(ProtocolVersion other) {
        if (this._major == other._major) {
            return Integer.compare(this._minor, other._minor);
        }
        return Integer.compare(this._major, other._major);
    }

    public boolean gt(ProtocolVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean gte(ProtocolVersion other) {
        return this.compareTo(other) >= 0;
    }

    public boolean lt(ProtocolVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean lte(ProtocolVersion other) {
        return this.compareTo(other) <= 0;
    }
}

