/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.httpclient.HttpClientProvider;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClient;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClientConfig;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class OAuthService
implements Closeable {
    private final OAuthConfig config;
    private final HttpClient httpClient;

    public OAuthService(OAuthConfig config) {
        this.config = config;
        HttpClientConfig httpClientConfig = config.getHttpClientConfig();
        HttpClient externalHttpClient = config.getHttpClient();
        this.httpClient = httpClientConfig == null && externalHttpClient == null ? new JDKHttpClient(JDKHttpClientConfig.defaultConfig()) : (externalHttpClient == null ? OAuthService.getClient(httpClientConfig) : externalHttpClient);
    }

    private static HttpClient getClient(HttpClientConfig config) {
        for (HttpClientProvider provider : ServiceLoader.load(HttpClientProvider.class)) {
            HttpClient client = provider.createClient(config);
            if (client == null) continue;
            return client;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public OAuthConfig getConfig() {
        return this.config;
    }

    public abstract String getVersion();

    public Future<Response> executeAsync(OAuthRequest request) {
        return this.execute(request, null);
    }

    public Future<Response> execute(OAuthRequest request, OAuthAsyncRequestCallback<Response> callback) {
        return this.execute(request, callback, null);
    }

    public <R> Future<R> execute(OAuthRequest request, OAuthAsyncRequestCallback<R> callback, OAuthRequest.ResponseConverter<R> converter) {
        File filePayload = request.getFilePayload();
        if (filePayload != null) {
            return this.httpClient.executeAsync(this.config.getUserAgent(), request.getHeaders(), request.getVerb(), request.getCompleteUrl(), filePayload, callback, converter);
        }
        if (request.getStringPayload() != null) {
            return this.httpClient.executeAsync(this.config.getUserAgent(), request.getHeaders(), request.getVerb(), request.getCompleteUrl(), request.getStringPayload(), callback, converter);
        }
        return this.httpClient.executeAsync(this.config.getUserAgent(), request.getHeaders(), request.getVerb(), request.getCompleteUrl(), request.getByteArrayPayload(), callback, converter);
    }

    public Response execute(OAuthRequest request) throws InterruptedException, ExecutionException, IOException {
        File filePayload = request.getFilePayload();
        if (filePayload != null) {
            return this.httpClient.execute(this.config.getUserAgent(), request.getHeaders(), request.getVerb(), request.getCompleteUrl(), filePayload);
        }
        if (request.getStringPayload() != null) {
            return this.httpClient.execute(this.config.getUserAgent(), request.getHeaders(), request.getVerb(), request.getCompleteUrl(), request.getStringPayload());
        }
        return this.httpClient.execute(this.config.getUserAgent(), request.getHeaders(), request.getVerb(), request.getCompleteUrl(), request.getByteArrayPayload());
    }
}

