/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.main;

import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import com.paterva.maltego.view.customization.api.Viewlet;
import com.paterva.maltego.view.customization.ui.main.NewViewletPanel;
import com.paterva.maltego.view.customization.ui.main.Viewlets;
import java.util.List;
import org.openide.WizardDescriptor;

public class NewViewletController
extends ValidatingController<NewViewletPanel> {
    private List<Viewlet> _viewlets;

    public NewViewletController(List<Viewlet> viewlets) {
        this._viewlets = viewlets;
    }

    public String getViewletName() {
        return ((NewViewletPanel)this.component()).getViewletName();
    }

    protected String getFirstError(NewViewletPanel component) {
        String name = component.getViewletName();
        if (StringUtilities.isNullOrEmpty((String)name)) {
            return "Please enter a name";
        }
        for (Viewlet viewlet : this._viewlets) {
            if (!viewlet.getName().equals(name)) continue;
            return "A Viewlet with the same name already exists";
        }
        return null;
    }

    protected NewViewletPanel createComponent() {
        NewViewletPanel panel = new NewViewletPanel();
        panel.setViewletName(this.createUniqueName("My Viewlet"));
        panel.addChangeListener(this.changeListener());
        return panel;
    }

    private String createUniqueName(String preferedString) {
        int index = 2;
        String name = preferedString;
        while (Viewlets.get(this._viewlets, name) != null) {
            name = preferedString + " " + index;
            ++index;
        }
        return name;
    }

    protected void readSettings(WizardDescriptor settings) {
    }

    protected void storeSettings(WizardDescriptor settings) {
    }
}

