/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.ui.graph.view2d.LinkEdgeRealizer;
import com.paterva.maltego.ui.graph.view2d.MaltegoGraph2DRenderer;
import com.paterva.maltego.ui.graph.view2d.VisiblePrunerOptions;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import yguard.A.A.C;
import yguard.A.A.E;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.A.Z;
import yguard.A.A._;
import yguard.A.J.BA;
import yguard.A.J.SA;
import yguard.A.J.U;
import yguard.A.J.q;

class VisiblePruner {
    private static final Logger LOG = Logger.getLogger(VisiblePruner.class.getName());
    private static final int MAX_PAINT_TIME = 100;
    private static final int MAX_ADJUST_FACTOR = 1;
    private static final int MAX_EDGES_TO_PAINT_FACTOR = 3;
    private static final int MAX_NODE_MAX = 50000;
    private static final int MAX_NODE_MIN = 100;
    private static final int ACTUAL_MIN_NODES = 2000;
    private static final double ZOOM_MAX_FACTOR = 10.0;
    private final MaltegoGraph2DRenderer _renderer;
    private final U _view;
    private int _maxNodesToPaint = 400;
    private final Set<BA> _visibleNodes = new HashSet<BA>();
    private final Set<q> _visibleEdges = new HashSet<q>();
    private boolean _hadToPruneNodes = false;
    private boolean _hadToPruneEdges = false;
    private final Set<HashedEdgeRealizer> _sortedEdgeRealizers = new HashSet<HashedEdgeRealizer>();
    private final Set<HashedNodeRealizer> _sortedNodeRealizers = new HashSet<HashedNodeRealizer>();

    public VisiblePruner(GraphID graphID, MaltegoGraph2DRenderer renderer, U view) {
        this._renderer = renderer;
        this._view = view;
        SA graph2D = this._view.getGraph2D();
        PruneGraphListener listener = new PruneGraphListener();
        graph2D.A((_)listener);
        GraphLifeCycleManager.getDefault().addPropertyChangeListener((PropertyChangeListener)new GraphCloseListener(graphID, graph2D, listener));
        this.addInitialNodes(graph2D);
        this.addInitialEdges(graph2D);
    }

    public synchronized Set<q> getVisibleEdges() {
        return this._visibleEdges;
    }

    public synchronized Set<BA> getVisibleNodes() {
        return this._visibleNodes;
    }

    public synchronized void adjustPaintMax(int paintTime) {
        if ((this._hadToPruneNodes || this._hadToPruneEdges) && (double)paintTime < 10.0 || (double)paintTime > 10.0) {
            long timeDiff = 100 - paintTime;
            this._maxNodesToPaint = (int)((long)this._maxNodesToPaint + timeDiff * 1L);
            this._maxNodesToPaint = Math.min(this._maxNodesToPaint, 50000);
            this._maxNodesToPaint = Math.max(this._maxNodesToPaint, 100);
            LOG.finer("Max adjusted");
        }
    }

    public synchronized void calculateVisibleNodes(SA graph, Rectangle2D visibleRect2D) {
        double zoom = this._view.getZoom();
        this._hadToPruneNodes = false;
        this._visibleNodes.clear();
        LinkedList<BA> visibleNodes = new LinkedList<BA>();
        int max = Math.max(2000, this._maxNodesToPaint);
        LOG.log(Level.FINER, "Max nodes: {0}", max);
        if (zoom < 0.9) {
            max = (int)((double)max * (-10.0 * zoom + 10.0));
            LOG.log(Level.FINER, "Max nodes: {0} (zoom accounted)", max);
        }
        for (HashedNodeRealizer nodeRealizer : this._sortedNodeRealizers) {
            if (visibleNodes.size() >= max) {
                this._hadToPruneNodes = true;
                break;
            }
            BA realizer = nodeRealizer.getRealizer();
            if (this._renderer.isPruneVisible() && !this._renderer.intersectsRegion(realizer, visibleRect2D)) continue;
            visibleNodes.add(realizer);
        }
        this._visibleNodes.addAll(visibleNodes);
    }

    public synchronized void calculateVisibleEdges(SA graph, Rectangle2D visibleRect2D) {
        double zoom = this._view.getZoom();
        this._hadToPruneEdges = false;
        this._visibleEdges.clear();
        LinkedList<q> visibleEdges = new LinkedList<q>();
        int max = this._maxNodesToPaint * 3;
        LOG.log(Level.FINER, "Max edges: {0}", max);
        if (zoom < 0.9) {
            max = (int)((double)max * (-10.0 * zoom + 10.0));
            LOG.log(Level.FINER, "Max edges: {0} (zoom accounted)", max);
        }
        boolean checkEndpointsInView = VisiblePrunerOptions.isHidePassthroughEdges() && this._sortedEdgeRealizers.size() > VisiblePrunerOptions.getStartHidingEdgesCount();
        LinkedList<q> endPointsNotInView = new LinkedList<q>();
        for (HashedEdgeRealizer edgeRealizer : this._sortedEdgeRealizers) {
            if (visibleEdges.size() >= max) {
                this._hadToPruneEdges = true;
                break;
            }
            q realizer = edgeRealizer.getRealizer();
            boolean mustAdd = true;
            if (!this._renderer.isPruneVisible()) {
                mustAdd = true;
            } else {
                boolean sourceInView;
                if (checkEndpointsInView && !(sourceInView = visibleRect2D.contains(realizer.getSourceIntersection()))) {
                    boolean inView;
                    mustAdd = inView = visibleRect2D.contains(realizer.getTargetIntersection());
                    if (!inView && this._renderer.intersectsRegion(realizer, visibleRect2D)) {
                        endPointsNotInView.add(realizer);
                    }
                }
                if (mustAdd) {
                    mustAdd = this._renderer.intersectsRegion(realizer, visibleRect2D);
                }
            }
            if (!mustAdd) continue;
            visibleEdges.add(realizer);
        }
        this._visibleEdges.addAll(visibleEdges);
        if (this._visibleEdges.size() < max && !endPointsNotInView.isEmpty()) {
            int toAdd = Math.min(endPointsNotInView.size(), max - this._visibleEdges.size());
            if ((toAdd /= 2) > 0) {
                this._visibleEdges.addAll(endPointsNotInView.subList(0, toAdd));
            }
        }
    }

    private void addInitialNodes(SA graph2D) {
        LinkedList<HashedNodeRealizer> nodeRealizers = new LinkedList<HashedNodeRealizer>();
        E nodes = graph2D.\u00a4();
        while (nodes.ok()) {
            Y node = nodes.B();
            BA realizer = this._view.getGraph2D().f(node);
            nodeRealizers.add(new HashedNodeRealizer(realizer));
            nodes.next();
        }
        this._sortedNodeRealizers.addAll(nodeRealizers);
    }

    private void addInitialEdges(SA graph2D) {
        LinkedList<HashedEdgeRealizer> edgeRealizers = new LinkedList<HashedEdgeRealizer>();
        Z edges = graph2D.u();
        while (edges.ok()) {
            H edge = edges.D();
            q realizer = this._view.getGraph2D().X(edge);
            edgeRealizers.add(new HashedEdgeRealizer(realizer));
            edges.next();
        }
        this._sortedEdgeRealizers.addAll(edgeRealizers);
    }

    private class GraphCloseListener
    implements PropertyChangeListener {
        private final GraphID _graphID;
        private final SA _graph2D;
        private final PruneGraphListener _listener;

        public GraphCloseListener(GraphID graphID, SA graph2D, PruneGraphListener listener) {
            this._graphID = graphID;
            this._graph2D = graph2D;
            this._listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            VisiblePruner visiblePruner = VisiblePruner.this;
            synchronized (visiblePruner) {
                GraphID closedGraphID;
                if ("graphClosing".equals(evt.getPropertyName()) && (closedGraphID = (GraphID)evt.getNewValue()).equals((Object)this._graphID)) {
                    this._graph2D.B((_)this._listener);
                    GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    }

    private class PruneGraphListener
    implements _ {
        private PruneGraphListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onGraphEvent(C e2) {
            VisiblePruner visiblePruner = VisiblePruner.this;
            synchronized (visiblePruner) {
                byte type = e2.C();
                if (type == 1 || type == 4) {
                    H edge = (H)e2.A();
                    q realizer = VisiblePruner.this._view.getGraph2D().X(edge);
                    if (type == 1) {
                        VisiblePruner.this._sortedEdgeRealizers.add(new HashedEdgeRealizer(realizer));
                    } else if (type == 4) {
                        VisiblePruner.this._sortedEdgeRealizers.remove(new HashedEdgeRealizer(realizer));
                    }
                } else if (type == 0 || type == 2) {
                    Y node = (Y)e2.A();
                    BA realizer = VisiblePruner.this._view.getGraph2D().f(node);
                    if (type == 0) {
                        VisiblePruner.this._sortedNodeRealizers.add(new HashedNodeRealizer(realizer));
                    } else if (type == 2) {
                        VisiblePruner.this._sortedNodeRealizers.remove(new HashedNodeRealizer(realizer));
                    }
                }
            }
        }
    }

    private class HashedEdgeRealizer {
        private final q _realizer;
        private final int _hash;

        public HashedEdgeRealizer(q realizer) {
            this._realizer = realizer;
            if (realizer instanceof LinkEdgeRealizer) {
                LinkEdgeRealizer linkEdgeRealizer = (LinkEdgeRealizer)realizer;
                this._hash = linkEdgeRealizer.getPaintHash();
            } else {
                this._hash = realizer.hashCode();
            }
        }

        public q getRealizer() {
            return this._realizer;
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HashedEdgeRealizer other = (HashedEdgeRealizer)obj;
            return Objects.equals(this._realizer, other._realizer);
        }
    }

    private class HashedNodeRealizer {
        private final BA _realizer;
        private final int _hash;

        public HashedNodeRealizer(BA realizer) {
            this._realizer = realizer;
            if (realizer instanceof LightweightEntityRealizer) {
                LightweightEntityRealizer entityRealizer = (LightweightEntityRealizer)realizer;
                this._hash = entityRealizer.getPaintHash();
            } else {
                this._hash = realizer.hashCode();
            }
        }

        public BA getRealizer() {
            return this._realizer;
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HashedNodeRealizer other = (HashedNodeRealizer)obj;
            return Objects.equals(this._realizer, other._realizer);
        }
    }
}

