/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.clipboard;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.ui.graph.actions.TopGraphEntitySelectionAction;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Set;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExTransferable;

public abstract class EntityStringCopyAction
extends TopGraphEntitySelectionAction {
    protected abstract String getStatusName();

    protected abstract String createString(GraphID var1);

    @Override
    protected void actionPerformed() {
        String text = this.performAction(this.getTopGraphID());
        String memSize = StringUtilities.getApproximateMemSize((String)text);
        StatusDisplayer.getDefault().setStatusText(this.getStatusName() + " copied to Clipboard (" + memSize + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String performAction(GraphID graphID) {
        String returnText = "";
        WindowUtil.showWaitCursor();
        try {
            String text;
            returnText = text = this.createString(graphID);
            ExTransferable.Single t = new ExTransferable.Single(DataFlavor.stringFlavor){

                protected Object getData() throws IOException, UnsupportedFlavorException {
                    return text;
                }
            };
            Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
            clipboard.setContents((Transferable)t, null);
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
        return returnText;
    }

    protected Set<EntityID> getSelection(GraphID graphID) {
        return this.getSelectedModelEntities();
    }
}

