/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.utils.bean;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ObjectIntrospector {
    private static final Query IDENTITY = new Query.Identity();

    public Object get(Object obj, String expression) {
        Query query = this.getQuery(expression);
        return query.get(obj);
    }

    public Object get(Object obj, String ... components) {
        Query query = this.getQuery(components);
        return query.get(obj);
    }

    public Query getQuery(String expression) {
        return Query.parse(expression);
    }

    public Query getQuery(String ... components) {
        return Query.parse(components);
    }

    public static abstract class Query {
        public abstract Object get(Object var1);

        public static Query parse(String expression) {
            if (expression == null || expression.trim().isEmpty()) {
                return IDENTITY;
            }
            String[] components = expression.split("\\.");
            return Query.parse(components);
        }

        public static Query parse(String ... components) {
            ArrayList<Query> queries = new ArrayList<Query>();
            for (String s : components) {
                queries.addAll(Arrays.asList(Query.parseQuery(s)));
            }
            if (queries.isEmpty()) {
                return IDENTITY;
            }
            if (queries.size() == 1) {
                return (Query)queries.get(0);
            }
            return new Compound(queries.toArray(new Query[queries.size()]));
        }

        private static Query[] parseQuery(String expression) {
            String[] splits = expression.split("\\[");
            Query[] queries = new Query[splits.length];
            for (int i = 0; i < splits.length; ++i) {
                String s = splits[i];
                queries[i] = s.endsWith("]") ? new Index(Query.parseIndex(s)) : new Field(s);
            }
            return queries;
        }

        private static int parseIndex(String expression) {
            if (expression.length() == 1) {
                return -1;
            }
            String s = expression.substring(0, expression.length() - 1);
            if ("last".equalsIgnoreCase(s)) {
                return Integer.MAX_VALUE;
            }
            return Integer.parseInt(s);
        }

        private static class Field
        extends Query {
            private final String _name;

            public Field(String name) {
                this._name = name;
            }

            @Override
            public Object get(Object obj) {
                if (obj == null) {
                    return null;
                }
                if (obj.getClass().isArray()) {
                    return this.getAll(obj);
                }
                if (obj instanceof List && !this.fieldExists(obj)) {
                    return this.getAll((List)obj);
                }
                return this.getObject(obj);
            }

            private Object[] getAll(List list) {
                Object[] result = new Object[list.size()];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = this.getObject(list.get(i));
                }
                return result;
            }

            private Object[] getAll(Object obj) {
                Object[] result = new Object[Array.getLength(obj)];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = this.getObject(Array.get(obj, i));
                }
                return result;
            }

            private Object getObject(Object obj) {
                if (obj == null) {
                    return null;
                }
                if (obj instanceof Map) {
                    Map map = (Map)obj;
                    return map.get(this._name);
                }
                return Field.getPropertyValue(obj, this._name);
            }

            private boolean fieldExists(Object obj) {
                if (obj instanceof Map) {
                    Map map = (Map)obj;
                    return map.containsKey(this._name);
                }
                return Field.getPropertyDescriptor(obj.getClass(), this._name) != null;
            }

            private static Object getPropertyValue(Object instance, String property) {
                try {
                    PropertyDescriptor d = Field.getPropertyDescriptor(instance.getClass(), property);
                    if (d == null) {
                        return null;
                    }
                    return d.getReadMethod().invoke(instance, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    return null;
                }
            }

            private static PropertyDescriptor getPropertyDescriptor(Class clazz, String property) {
                try {
                    for (PropertyDescriptor pd : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                        if (!pd.getName().equals(property)) continue;
                        return pd;
                    }
                    return null;
                }
                catch (IntrospectionException ex) {
                    return null;
                }
            }

            public String toString() {
                return this._name;
            }
        }

        private static class Index
        extends Query {
            private final int _index;
            private static final int ALL = -1;
            private static final int LAST = Integer.MAX_VALUE;

            public Index(int index) {
                this._index = index;
            }

            @Override
            public Object get(Object obj) {
                if (obj == null) {
                    return null;
                }
                if (obj.getClass().isArray()) {
                    return Index.getFromArray(obj, this._index);
                }
                if (obj instanceof List) {
                    return Index.getFromList((List)obj, this._index);
                }
                if (obj instanceof Iterable) {
                    return Index.getFromIterable((Iterable)obj, this._index);
                }
                if (this._index == -1) {
                    return new Object[]{obj};
                }
                return null;
            }

            private static Object getFromArray(Object array, int index) {
                if (index == -1) {
                    return array;
                }
                int size = Array.getLength(array);
                if (index == Integer.MAX_VALUE) {
                    index = size - 1;
                }
                if (index >= size || index < 0) {
                    return null;
                }
                return Array.get(array, index);
            }

            private static Object getFromList(List list, int index) {
                if (index == -1) {
                    return list.toArray();
                }
                int size = list.size();
                if (index == Integer.MAX_VALUE) {
                    index = size - 1;
                }
                if (index >= size || index < 0) {
                    return null;
                }
                return list.get(index);
            }

            private static Object getFromIterable(Iterable iterable, int index) {
                if (index == -1) {
                    ArrayList list = new ArrayList();
                    for (Object o : iterable) {
                        list.add(o);
                    }
                    return list.toArray();
                }
                int pos = 0;
                Object result = null;
                for (Object o : iterable) {
                    result = o;
                    if (pos == index) {
                        return result;
                    }
                    ++pos;
                }
                if (index == Integer.MAX_VALUE) {
                    return result;
                }
                return null;
            }

            public String toString() {
                switch (this._index) {
                    case -1: {
                        return "[]";
                    }
                    case 0x7FFFFFFF: {
                        return "[last]";
                    }
                }
                return "[" + this._index + "]";
            }
        }

        private static class Compound
        extends Query {
            private final Query[] _queries;

            public Compound(Query ... queries) {
                this._queries = queries;
            }

            @Override
            public Object get(Object obj) {
                for (Query q : this._queries) {
                    if ((obj = q.get(obj)) != null) continue;
                    return null;
                }
                return obj;
            }

            public String toString() {
                StringBuilder buffer = new StringBuilder();
                for (Query q : this._queries) {
                    buffer.append(q.toString());
                }
                return buffer.toString();
            }
        }

        private static class Identity
        extends Query {
            private Identity() {
            }

            @Override
            public Object get(Object obj) {
                return obj;
            }

            public String toString() {
                return "";
            }
        }
    }
}

