/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.ArrayFunctionBuiltins;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ArrayAllocationSite;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.SparseArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantByteArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantEmptyPrototypeArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantIntArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyRegexResultArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyRegexResultIndicesArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedIntArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import java.util.ArrayList;
import java.util.List;

public final class JSArray
extends JSAbstractArray
implements JSConstructorFactory.WithFunctionsAndSpecies,
PrototypeSupplier {
    public static final String CLASS_NAME = "Array";
    public static final String PROTOTYPE_NAME = "Array.prototype";
    public static final String ITERATOR_CLASS_NAME = "Array Iterator";
    public static final String ITERATOR_PROTOTYPE_NAME = "Array Iterator.prototype";
    public static final String ENTRIES = "entries";
    public static final JSArray INSTANCE = new JSArray();
    static final ArrayLengthProxyProperty ARRAY_LENGTH_PROPERTY_PROXY = new ArrayLengthProxyProperty();
    public static final HiddenKey ARRAY_ITERATION_KIND_ID = new HiddenKey("ArrayIterationKind");

    private JSArray() {
    }

    public static DynamicObject createConstant(JSContext context, JSRealm realm, Object[] elements) {
        return JSArray.create(context, realm, ScriptArray.createConstantArray(elements), elements, elements.length);
    }

    public static DynamicObject createEmpty(JSContext context, JSRealm realm, int length) {
        if (length < 0) {
            throw Errors.createRangeErrorInvalidArrayLength();
        }
        return JSArray.createEmptyChecked(context, realm, length);
    }

    private static DynamicObject createEmptyChecked(JSContext context, JSRealm realm, int length) {
        return JSArray.createConstantEmptyArray(context, realm, length);
    }

    public static DynamicObject createEmpty(JSContext context, JSRealm realm, long length) {
        if (!JSRuntime.isValidArrayLength(length)) {
            throw Errors.createRangeErrorInvalidArrayLength();
        }
        if (length > Integer.MAX_VALUE) {
            return JSArray.createSparseArray(context, realm, length);
        }
        return JSArray.createEmptyChecked(context, realm, length);
    }

    public static DynamicObject createEmptyChecked(JSContext context, JSRealm realm, long length) {
        assert (0L <= length && length <= Integer.MAX_VALUE);
        return JSArray.createConstantEmptyArray(context, realm, (int)length);
    }

    public static DynamicObject createEmptyZeroLength(JSContext context, JSRealm realm) {
        return JSArray.createConstantEmptyArray(context, realm);
    }

    public static DynamicObject create(JSContext context, JSRealm realm, ScriptArray arrayType, Object array, long length) {
        return JSArray.create(context, realm, arrayType, array, length, 0);
    }

    public static DynamicObject create(JSContext context, JSRealm realm, ScriptArray arrayType, Object array, long length, int usedLength) {
        return JSArray.create(context, realm, arrayType, array, length, usedLength, 0, 0);
    }

    public static DynamicObject create(JSContext context, JSRealm realm, ScriptArray arrayType, Object array, long length, int usedLength, int indexOffset, int arrayOffset) {
        return JSArray.create(context, realm, arrayType, array, length, usedLength, indexOffset, arrayOffset, 0);
    }

    public static DynamicObject create(JSContext context, JSRealm realm, ScriptArray arrayType, Object array, long length, int usedLength, int indexOffset, int arrayOffset, int holeCount) {
        return JSArray.createImpl(context, realm, arrayType, array, null, length, usedLength, indexOffset, arrayOffset, holeCount);
    }

    public static DynamicObject create(JSContext context, JSRealm realm, ScriptArray arrayType, Object array, ArrayAllocationSite site, long length, int usedLength, int indexOffset, int arrayOffset, int holeCount) {
        return JSArray.createImpl(context, realm, arrayType, array, site, length, usedLength, indexOffset, arrayOffset, holeCount);
    }

    private static DynamicObject createImpl(JSContext context, JSRealm realm, ScriptArray arrayType, Object array, ArrayAllocationSite site, long length, int usedLength, int indexOffset, int arrayOffset, int holeCount) {
        assert (JSRuntime.isRepresentableAsUnsignedInt(length));
        JSObjectFactory factory = context.getArrayFactory();
        DynamicObject obj = JSArrayObject.create(factory.getShape(realm), arrayType, array, site, length, usedLength, indexOffset, arrayOffset, holeCount);
        factory.initProto(obj, realm);
        assert (JSArray.isJSArray(obj));
        return context.trackAllocation(obj);
    }

    public static boolean isJSArray(Object obj) {
        return obj instanceof JSArrayObject;
    }

    public static boolean isJSFastArray(Object obj) {
        return JSArray.isJSArray(obj) && JSArray.isJSFastArray((JSArrayObject)obj);
    }

    public static boolean isJSFastArray(DynamicObject obj) {
        return JSArray.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        Shape protoShape = JSShape.createPrototypeShape(ctx, INSTANCE, realm.getObjectPrototype());
        DynamicObject arrayPrototype = JSArrayObject.createEmpty(protoShape, ConstantEmptyPrototypeArray.createConstantEmptyPrototypeArray());
        JSObjectUtil.setOrVerifyPrototype(ctx, arrayPrototype, realm.getObjectPrototype());
        JSObjectUtil.putConstructorProperty(ctx, arrayPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, arrayPrototype, ArrayPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putProxyProperty(arrayPrototype, "length", ARRAY_LENGTH_PROPERTY_PROXY, JSAttributes.notConfigurableNotEnumerableWritable());
        if (ctx.getEcmaScriptVersion() >= 6) {
            JSObjectUtil.putDataProperty(ctx, arrayPrototype, Symbol.SYMBOL_ITERATOR, JSDynamicObject.getOrNull(arrayPrototype, "values"), JSAttributes.getDefaultNotEnumerable());
            JSObjectUtil.putDataProperty(ctx, arrayPrototype, Symbol.SYMBOL_UNSCOPABLES, JSArray.createUnscopables(ctx, JSArray.unscopableNameList(ctx)), JSAttributes.configurableNotEnumerableNotWritable());
        }
        return arrayPrototype;
    }

    private static List<String> unscopableNameList(JSContext context) {
        ArrayList<String> names = new ArrayList<String>();
        if (context.getEcmaScriptVersion() >= 13) {
            names.add("at");
        }
        names.add("copyWithin");
        names.add(ENTRIES);
        names.add("fill");
        names.add("find");
        names.add("findIndex");
        if (context.getEcmaScriptVersion() >= 10) {
            names.add("flat");
            names.add("flatMap");
        }
        if (context.getEcmaScriptVersion() >= 7) {
            names.add("includes");
        }
        names.add("keys");
        names.add("values");
        return names;
    }

    private static DynamicObject createUnscopables(JSContext context, List<String> unscopableNames) {
        DynamicObject unscopables = JSOrdinary.createWithNullPrototypeInit(context);
        for (String name : unscopableNames) {
            JSObjectUtil.putDataProperty(context, unscopables, name, true, JSAttributes.getDefault());
        }
        return unscopables;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        initialShape = Shape.newBuilder((Shape)initialShape).addConstantProperty((Object)"length", (Object)ARRAY_LENGTH_PROPERTY_PROXY, JSAttributes.notConfigurableNotEnumerableWritable() | 0x10).build();
        return initialShape;
    }

    @Override
    public List<Object> getOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        return JSArray.ownPropertyKeysFastArray(thisObj, strings, symbols);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, ArrayFunctionBuiltins.BUILTINS);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean setLength(DynamicObject store, Object value) {
        long arrLength = 0L;
        arrLength = value instanceof Integer && (Integer)value >= 0 ? (long)((Integer)value).intValue() : JSArray.toArrayLengthOrRangeError(value);
        assert (arrLength >= 0L);
        return !JSAbstractArray.arrayGetArrayType(store).isLengthNotWritable() && ((JSAbstractArray)JSObject.getJSClass(store)).setLength(store, arrLength, false);
    }

    public static DynamicObject createConstantEmptyArray(JSContext context, JSRealm realm, int capacity) {
        AbstractConstantArray arrayType = ScriptArray.createConstantEmptyArray();
        return JSArray.create(context, realm, arrayType, ScriptArray.EMPTY_OBJECT_ARRAY, capacity);
    }

    public static DynamicObject createConstantEmptyArray(JSContext context, JSRealm realm) {
        return JSArray.createConstantEmptyArray(context, realm, 0);
    }

    public static DynamicObject createConstantEmptyArray(JSContext context, JSRealm realm, ArrayAllocationSite site) {
        return JSArray.createConstantEmptyArray(context, realm, site, 0);
    }

    public static DynamicObject createConstantEmptyArray(JSContext context, JSRealm realm, ArrayAllocationSite site, int capacity) {
        AbstractConstantArray arrayType = ScriptArray.createConstantEmptyArray();
        return JSArray.create(context, realm, arrayType, ScriptArray.EMPTY_OBJECT_ARRAY, site, capacity, 0, 0, 0, 0);
    }

    public static DynamicObject createConstantByteArray(JSContext context, JSRealm realm, byte[] byteArray) {
        ConstantByteArray arrayType = ConstantByteArray.createConstantByteArray();
        return JSArray.create(context, realm, arrayType, byteArray, byteArray.length);
    }

    public static DynamicObject createConstantIntArray(JSContext context, JSRealm realm, int[] intArray) {
        ConstantIntArray arrayType = ConstantIntArray.createConstantIntArray();
        return JSArray.create(context, realm, arrayType, intArray, intArray.length);
    }

    public static DynamicObject createConstantDoubleArray(JSContext context, JSRealm realm, double[] doubleArray) {
        ConstantDoubleArray arrayType = ConstantDoubleArray.createConstantDoubleArray();
        return JSArray.create(context, realm, arrayType, doubleArray, doubleArray.length);
    }

    public static DynamicObject createConstantObjectArray(JSContext context, JSRealm realm, Object[] objectArray) {
        ConstantObjectArray arrayType = ConstantObjectArray.createConstantObjectArray();
        return JSArray.create(context, realm, arrayType, objectArray, objectArray.length);
    }

    public static DynamicObject createZeroBasedHolesObjectArray(JSContext context, JSRealm realm, Object[] objectArray, int usedLength, int arrayOffset, int holeCount) {
        return JSArray.create(context, realm, HolesObjectArray.createHolesObjectArray(), objectArray, objectArray.length, usedLength, 0, arrayOffset, holeCount);
    }

    public static DynamicObject createZeroBasedIntArray(JSContext context, JSRealm realm, int[] intArray) {
        return JSArray.create(context, realm, ZeroBasedIntArray.createZeroBasedIntArray(), intArray, intArray.length, intArray.length, 0, 0);
    }

    public static DynamicObject createZeroBasedDoubleArray(JSContext context, JSRealm realm, double[] doubleArray) {
        return JSArray.create(context, realm, ZeroBasedDoubleArray.createZeroBasedDoubleArray(), doubleArray, doubleArray.length, doubleArray.length, 0, 0);
    }

    public static DynamicObject createZeroBasedObjectArray(JSContext context, JSRealm realm, Object[] objectArray) {
        return JSArray.create(context, realm, ZeroBasedObjectArray.createZeroBasedObjectArray(), objectArray, objectArray.length, objectArray.length, 0, 0);
    }

    public static DynamicObject createZeroBasedJSObjectArray(JSContext context, JSRealm realm, DynamicObject[] objectArray) {
        return JSArray.create(context, realm, ZeroBasedJSObjectArray.createZeroBasedJSObjectArray(), objectArray, objectArray.length, objectArray.length, 0, 0);
    }

    public static DynamicObject createSparseArray(JSContext context, JSRealm realm, long length) {
        return JSArray.create(context, realm, SparseArray.createSparseArray(), SparseArray.createArrayMap(), length);
    }

    public static DynamicObject createLazyRegexArray(JSContext context, JSRealm realm, int length) {
        assert (JSRuntime.isRepresentableAsUnsignedInt(length));
        Object[] array = new Object[length];
        return JSArray.create(context, realm, LazyRegexResultArray.createLazyRegexResultArray(), array, length);
    }

    public static DynamicObject createLazyRegexArray(JSContext context, JSRealm realm, int length, Object regexResult, String input, DynamicObject groups, DynamicObject indicesGroups) {
        assert (JSRuntime.isRepresentableAsUnsignedInt(length));
        DynamicObject obj = JSArray.createLazyRegexArray(context, realm, length);
        JSObjectUtil.putHiddenProperty(obj, LAZY_REGEX_RESULT_ID, regexResult);
        JSObjectUtil.putHiddenProperty(obj, LAZY_REGEX_ORIGINAL_INPUT_ID, input);
        JSObjectUtil.putProxyProperty(obj, "index", JSRegExp.LAZY_INDEX_PROXY, JSAttributes.getDefault());
        JSObjectUtil.putDataProperty(context, obj, "input", input, JSAttributes.getDefault());
        JSObjectUtil.putDataProperty(context, obj, "groups", groups, JSAttributes.getDefault());
        if (context.isOptionRegexpMatchIndices()) {
            DynamicObject indices = JSArray.createLazyRegexIndicesArray(context, realm, length, regexResult, indicesGroups);
            JSObjectUtil.putDataProperty(context, obj, "indices", indices, JSAttributes.getDefault());
        }
        assert (JSArray.isJSArray(obj));
        return obj;
    }

    public static DynamicObject createLazyRegexIndicesArray(JSContext context, JSRealm realm, int length) {
        assert (JSRuntime.isRepresentableAsUnsignedInt(length));
        Object[] array = new Object[length];
        return JSArray.create(context, realm, LazyRegexResultIndicesArray.createLazyRegexResultIndicesArray(), array, length);
    }

    private static DynamicObject createLazyRegexIndicesArray(JSContext context, JSRealm realm, int length, Object regexResult, DynamicObject indicesGroups) {
        assert (JSRuntime.isRepresentableAsUnsignedInt(length));
        Object[] array = new Object[length];
        DynamicObject obj = JSArray.create(context, realm, LazyRegexResultIndicesArray.createLazyRegexResultIndicesArray(), array, length);
        JSObjectUtil.putHiddenProperty(obj, LAZY_REGEX_RESULT_ID, regexResult);
        JSObjectUtil.putDataProperty(context, obj, "groups", indicesGroups, JSAttributes.getDefault());
        assert (JSArray.isJSArray(obj));
        return obj;
    }

    public static DynamicObject createLazyArray(JSContext context, JSRealm realm, List<?> list, int size) {
        assert (list.size() == size);
        return JSArray.create(context, realm, LazyArray.createLazyArray(), list, size);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getArrayPrototype();
    }

    public static class ArrayLengthProxyProperty
    implements PropertyProxy {
        @Override
        public Object get(DynamicObject store) {
            assert (JSArray.isJSArray(store));
            long length = INSTANCE.getLength(store);
            return (double)length;
        }

        @Override
        public boolean set(DynamicObject store, Object value) {
            assert (JSArray.isJSArray(store));
            return JSArray.setLength(store, value);
        }
    }
}

