/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser;

import com.oracle.js.parser.JSErrorType;
import com.oracle.js.parser.ParserException;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.ScriptNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.EvalNode;
import com.oracle.truffle.js.nodes.function.FunctionRootNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import com.oracle.truffle.js.parser.BinarySnapshotProvider;
import com.oracle.truffle.js.parser.DirectEvalContext;
import com.oracle.truffle.js.parser.GraalJSParserHelper;
import com.oracle.truffle.js.parser.JSParser;
import com.oracle.truffle.js.parser.JavaScriptTranslator;
import com.oracle.truffle.js.parser.SnapshotProvider;
import com.oracle.truffle.js.parser.date.DateParser;
import com.oracle.truffle.js.parser.env.DebugEnvironment;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSParserOptions;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespace;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespaceObject;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import com.oracle.truffle.js.runtime.objects.JSModuleData;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;

public final class GraalJSEvaluator
implements JSParser {
    private static final HiddenKey STORE_MODULE_KEY = new HiddenKey("store-module-key");

    @Override
    public ScriptNode parseEval(JSContext context, Node lastNode, Source source) {
        return GraalJSEvaluator.parseEval(context, lastNode, source, false, null);
    }

    @Override
    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    public ScriptNode parseFunction(JSContext context, String parameterList, String body, boolean generatorFunction, boolean asyncFunction, String sourceName) {
        String wrappedBody = '\n' + body + '\n';
        try {
            GraalJSParserHelper.checkFunctionSyntax(context, context.getParserOptions(), parameterList, wrappedBody, generatorFunction, asyncFunction, sourceName);
        }
        catch (ParserException e) {
            e.setLineNumber(e.getLineNumber() - 1);
            throw GraalJSEvaluator.parserToJSError(null, e, context);
        }
        StringBuilder code = new StringBuilder();
        if (asyncFunction) {
            code.append("(async function");
        } else {
            code.append("(function");
        }
        if (generatorFunction) {
            code.append("*");
        }
        if (context.getEcmaScriptVersion() >= 6) {
            code.append(" anonymous");
        }
        if (context.isOptionNashornCompatibilityMode()) {
            code.append(' ');
        }
        code.append('(');
        code.append(parameterList);
        code.append('\n');
        code.append(") {");
        code.append(wrappedBody);
        code.append("})");
        Source source = Source.newBuilder((String)"js", (CharSequence)code.toString(), (String)sourceName).build();
        return GraalJSEvaluator.parseEval(context, null, source, false, null);
    }

    @Override
    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    public ScriptNode parseDirectEval(JSContext context, Node lastNode, Source source, Object evalEnv) {
        DirectEvalContext directEval = (DirectEvalContext)evalEnv;
        return GraalJSEvaluator.parseEval(context, lastNode, source, directEval.env.isStrictMode(), directEval);
    }

    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    private static ScriptNode parseEval(JSContext context, Node lastNode, Source source, boolean isStrict, DirectEvalContext directEval) {
        context.checkEvalAllowed();
        NodeFactory nodeFactory = NodeFactory.getInstance(context);
        try {
            return JavaScriptTranslator.translateEvalScript(nodeFactory, context, source, isStrict, directEval);
        }
        catch (ParserException e) {
            throw GraalJSEvaluator.parserToJSError(lastNode, e, context);
        }
    }

    private static JSException parserToJSError(Node lastNode, ParserException e, JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        String message = e.getMessage().replace("\r\n", "\n");
        if (e.getErrorType() == JSErrorType.ReferenceError) {
            return Errors.createReferenceError(message, e, lastNode);
        }
        assert (e.getErrorType() == JSErrorType.SyntaxError);
        if (context.isOptionNashornCompatibilityMode() && lastNode instanceof EvalNode) {
            SourceSection sourceSection = lastNode.getSourceSection();
            String name = sourceSection.getSource().getName();
            int lineNumber = sourceSection.getStartLine();
            int columnNumber = sourceSection.getStartColumn() - 1;
            message = name + '#' + lineNumber + ':' + columnNumber + message;
        }
        return Errors.createSyntaxError(message, e, lastNode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public ScriptNode evalCompile(JSContext context, String sourceCode, String name) {
        try {
            context.checkEvalAllowed();
            return JavaScriptTranslator.translateScript(NodeFactory.getInstance(context), context, Source.newBuilder((String)"js", (CharSequence)sourceCode, (String)name).build(), false, "", "");
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e.getMessage());
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public ScriptNode parseScript(JSContext context, Source source, String prolog, String epilog, String[] argumentNames) {
        if (GraalJSEvaluator.isModuleSource(source)) {
            return this.fakeScriptForModule(context, source);
        }
        try {
            return JavaScriptTranslator.translateScript(NodeFactory.getInstance(context), context, source, context.getParserOptions().isStrict(), prolog, epilog, argumentNames);
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e.getMessage());
        }
    }

    private static boolean isModuleSource(Source source) {
        String mimeType = source.getMimeType();
        return "application/javascript+module".equals(mimeType) || mimeType == null && source.getName().endsWith(".mjs");
    }

    private ScriptNode fakeScriptForModule(JSContext context, Source source) {
        JSModuleData parsedModule = this.parseModule(context, source);
        ModuleScriptRoot rootNode = new ModuleScriptRoot(context, parsedModule, source);
        JSFunctionData functionData = JSFunctionData.createCallOnly(context, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)rootNode), 0, "");
        return ScriptNode.fromFunctionData(functionData);
    }

    private static DynamicObject createTopLevelAwaitReject(JSContext context, JSRealm realm) {
        JSFunctionData functionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.TopLevelAwaitReject, c -> GraalJSEvaluator.createTopLevelAwaitRejectImpl(c));
        return JSFunction.create(realm, functionData);
    }

    private static JSFunctionData createTopLevelAwaitRejectImpl(JSContext context) {
        class TopLevelAwaitRejectedRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode argumentNode = AccessIndexedArgumentNode.create(0);

            TopLevelAwaitRejectedRootNode() {
            }

            public Object execute(VirtualFrame frame) {
                Object error = this.argumentNode.execute(frame);
                throw JSRuntime.getException(error);
            }
        }
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new TopLevelAwaitRejectedRootNode());
        return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 1, "");
    }

    private static DynamicObject createTopLevelAwaitResolve(JSContext context, JSRealm realm) {
        JSFunctionData functionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.TopLevelAwaitResolve, c -> GraalJSEvaluator.createTopLevelAwaitResolveImpl(c));
        return JSFunction.create(realm, functionData);
    }

    private static JSFunctionData createTopLevelAwaitResolveImpl(JSContext context) {
        class TopLevelAwaitFulfilledRootNode
        extends JavaScriptRootNode {
            TopLevelAwaitFulfilledRootNode() {
            }

            public Object execute(VirtualFrame frame) {
                return Undefined.instance;
            }
        }
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new TopLevelAwaitFulfilledRootNode());
        return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 1, "");
    }

    @Override
    public ScriptNode parseScript(JSContext context, String sourceCode) {
        try {
            return JavaScriptTranslator.translateScript(NodeFactory.getInstance(context), context, Source.newBuilder((String)"js", (CharSequence)sourceCode, (String)"<unknown>").build(), false, "", "");
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e.getMessage());
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Integer[] parseDate(JSRealm realm, String date) {
        DateParser dateParser = new DateParser(realm, date);
        return dateParser.parse() ? dateParser.getDateFields() : null;
    }

    @Override
    public String parseToJSON(JSContext context, String code, String name, boolean includeLoc) {
        return GraalJSParserHelper.parseToJSON(code, name, includeLoc, context.getParserOptions());
    }

    @Override
    public Object getDefaultNodeFactory() {
        return NodeFactory.getDefaultInstance();
    }

    public static Supplier<ScriptNode> internalParseForTiming(JSContext context, Source source) {
        FunctionNode ast = GraalJSParserHelper.parseScript(context, source, new JSParserOptions());
        return () -> JavaScriptTranslator.translateFunction(NodeFactory.getInstance(context), context, null, source, 0, false, ast);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JSModuleData parseModule(JSContext context, Source source) {
        try {
            return JavaScriptTranslator.translateModule(NodeFactory.getInstance(context), context, source);
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e.getMessage(), e, null);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JSModuleData envParseModule(JSRealm realm, Source source) {
        assert (GraalJSEvaluator.isModuleSource(source)) : source;
        CallTarget parseResult = realm.getEnv().parsePublic(source, new String[0]);
        CallTarget moduleScriptCallTarget = JavaScriptLanguage.getParsedProgramCallTarget(((RootCallTarget)parseResult).getRootNode());
        ModuleScriptRoot moduleScriptRoot = (ModuleScriptRoot)((RootCallTarget)moduleScriptCallTarget).getRootNode();
        return moduleScriptRoot.getModuleData();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JSModuleRecord parseJSONModule(JSRealm realm, Source source) {
        assert (GraalJSEvaluator.isModuleSource(source)) : source;
        Object json = JSFunction.call(JSArguments.createOneArg((Object)Undefined.instance, realm.getJsonParseFunctionObject(), source.getCharacters().toString()));
        return GraalJSEvaluator.createSyntheticJSONModule(realm, source, json);
    }

    private static JSModuleRecord createSyntheticJSONModule(JSRealm realm, Source source, Object hostDefined) {
        String exportName = "default";
        FrameDescriptor frameDescriptor = new FrameDescriptor((Object)Undefined.instance);
        final FrameSlot slot = frameDescriptor.addFrameSlot((Object)"default");
        List<Module.ExportEntry> localExportEntries = Collections.singletonList(Module.ExportEntry.exportSpecifier("default"));
        Module moduleNode = new Module(Collections.emptyList(), Collections.emptyList(), localExportEntries, Collections.emptyList(), Collections.emptyList(), null, null);
        JavaScriptRootNode rootNode = new JavaScriptRootNode(realm.getContext().getLanguage(), source.createUnavailableSection(), frameDescriptor){
            private final FrameSlot defaultSlot;
            {
                super(x0, x1, x2);
                this.defaultSlot = slot;
            }

            public Object execute(VirtualFrame frame) {
                JSModuleRecord module = (JSModuleRecord)JSArguments.getUserArgument(frame.getArguments(), 0);
                if (module.getEnvironment() == null) {
                    assert (module.getStatus() == JSModuleRecord.Status.Linking);
                    module.setEnvironment(frame.materialize());
                } else {
                    assert (module.getStatus() == JSModuleRecord.Status.Evaluating);
                    this.setSyntheticModuleExport(module);
                }
                return Undefined.instance;
            }

            private void setSyntheticModuleExport(JSModuleRecord module) {
                module.getEnvironment().setObject(this.defaultSlot, module.getHostDefined());
            }
        };
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
        JSFunctionData functionData = JSFunctionData.create(realm.getContext(), (CallTarget)callTarget, (CallTarget)callTarget, 0, "", false, false, true, true);
        JSModuleData parseModule = new JSModuleData(moduleNode, source, functionData, frameDescriptor);
        return new JSModuleRecord(parseModule, realm.getModuleLoader(), hostDefined);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JSModuleRecord hostResolveImportedModule(JSContext context, ScriptOrModule referrer, Module.ModuleRequest moduleRequest) {
        GraalJSEvaluator.filterSupportedImportAssertions(context, moduleRequest);
        JSModuleLoader moduleLoader = referrer instanceof JSModuleRecord ? ((JSModuleRecord)referrer).getModuleLoader() : JSRealm.get(null).getModuleLoader();
        return moduleLoader.resolveImportedModule(referrer, moduleRequest);
    }

    private static JSModuleRecord hostResolveImportedModule(JSModuleRecord referencingModule, Module.ModuleRequest moduleRequest) {
        GraalJSEvaluator.filterSupportedImportAssertions(referencingModule.getContext(), moduleRequest);
        return referencingModule.getModuleLoader().resolveImportedModule(referencingModule, moduleRequest);
    }

    private static void filterSupportedImportAssertions(JSContext context, Module.ModuleRequest moduleRequest) {
        if (moduleRequest.getAssertions().isEmpty()) {
            return;
        }
        HashMap<String, String> supportedAssertions = new HashMap<String, String>();
        for (Map.Entry<String, String> assertion : moduleRequest.getAssertions().entrySet()) {
            String key = assertion.getKey();
            String value = assertion.getValue();
            if (!context.getSupportedImportAssertions().contains(key)) continue;
            supportedAssertions.put(key, value);
        }
        moduleRequest.setAssertions(supportedAssertions);
    }

    Collection<String> getExportedNames(JSModuleRecord moduleRecord) {
        return this.getExportedNames(moduleRecord, new HashSet<JSModuleRecord>());
    }

    private Collection<String> getExportedNames(JSModuleRecord moduleRecord, Set<JSModuleRecord> exportStarSet) {
        if (exportStarSet.contains(moduleRecord)) {
            return Collections.emptySortedSet();
        }
        exportStarSet.add(moduleRecord);
        HashSet<String> exportedNames = new HashSet<String>();
        Module module = moduleRecord.getModule();
        for (Module.ExportEntry exportEntry : module.getLocalExportEntries()) {
            exportedNames.add(exportEntry.getExportName());
        }
        for (Module.ExportEntry exportEntry : module.getIndirectExportEntries()) {
            exportedNames.add(exportEntry.getExportName());
        }
        for (Module.ExportEntry exportEntry : module.getStarExportEntries()) {
            JSModuleRecord requestedModule = GraalJSEvaluator.hostResolveImportedModule(moduleRecord, exportEntry.getModuleRequest());
            Collection<String> starNames = this.getExportedNames(requestedModule, exportStarSet);
            for (String starName : starNames) {
                if (starName.equals("default") || exportedNames.contains(starName)) continue;
                exportedNames.add(starName);
            }
        }
        return exportedNames;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public ExportResolution resolveExport(JSModuleRecord referencingModule, String exportName) {
        return this.resolveExport(referencingModule, exportName, new HashSet<Pair<JSModuleRecord, String>>());
    }

    private ExportResolution resolveExport(JSModuleRecord referencingModule, String exportName, Set<Pair<JSModuleRecord, String>> resolveSet) {
        Pair<JSModuleRecord, String> resolved = new Pair<JSModuleRecord, String>(referencingModule, exportName);
        if (resolveSet.contains(resolved)) {
            return ExportResolution.notFound();
        }
        resolveSet.add(resolved);
        Module module = referencingModule.getModule();
        for (Module.ExportEntry exportEntry : module.getLocalExportEntries()) {
            if (!exportEntry.getExportName().equals(exportName)) continue;
            return ExportResolution.resolved(referencingModule, exportEntry.getLocalName());
        }
        for (Module.ExportEntry exportEntry : module.getIndirectExportEntries()) {
            if (!exportEntry.getExportName().equals(exportName)) continue;
            JSModuleRecord importedModule = GraalJSEvaluator.hostResolveImportedModule(referencingModule, exportEntry.getModuleRequest());
            if (exportEntry.getImportName().equals("*")) {
                return ExportResolution.resolved(importedModule, "*namespace*");
            }
            return this.resolveExport(importedModule, exportEntry.getImportName(), resolveSet);
        }
        if (exportName.equals("default")) {
            return ExportResolution.notFound();
        }
        ExportResolution starResolution = ExportResolution.notFound();
        for (Module.ExportEntry exportEntry : module.getStarExportEntries()) {
            JSModuleRecord importedModule = GraalJSEvaluator.hostResolveImportedModule(referencingModule, exportEntry.getModuleRequest());
            ExportResolution resolution = this.resolveExport(importedModule, exportName, resolveSet);
            if (resolution.isAmbiguous()) {
                return resolution;
            }
            if (resolution.isNull()) continue;
            if (starResolution.isNull()) {
                starResolution = resolution;
                continue;
            }
            if (resolution.equals(starResolution)) continue;
            return ExportResolution.ambiguous();
        }
        return starResolution;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public DynamicObject getModuleNamespace(JSModuleRecord moduleRecord) {
        if (moduleRecord.getNamespace() != null) {
            return moduleRecord.getNamespace();
        }
        assert (moduleRecord.getStatus() != JSModuleRecord.Status.Unlinked);
        Collection<String> exportedNames = this.getExportedNames(moduleRecord);
        ArrayList<Map.Entry<String, ExportResolution>> unambiguousNames = new ArrayList<Map.Entry<String, ExportResolution>>();
        for (String exportedName : exportedNames) {
            ExportResolution resolution = this.resolveExport(moduleRecord, exportedName);
            if (resolution.isNull()) {
                throw Errors.createSyntaxError("Could not resolve export");
            }
            if (resolution.isAmbiguous()) continue;
            unambiguousNames.add(new AbstractMap.SimpleImmutableEntry<String, ExportResolution>(exportedName, resolution));
        }
        unambiguousNames.sort(Map.Entry.comparingByKey());
        JSModuleNamespaceObject namespace = JSModuleNamespace.create(moduleRecord.getContext(), JSRealm.get(null), moduleRecord, unambiguousNames);
        moduleRecord.setNamespace(namespace);
        return namespace;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void moduleInstantiation(JSRealm realm, JSModuleRecord moduleRecord) {
        assert (moduleRecord.getStatus() != JSModuleRecord.Status.Linking && moduleRecord.getStatus() != JSModuleRecord.Status.Evaluating);
        ArrayDeque<JSModuleRecord> stack = new ArrayDeque<JSModuleRecord>(4);
        try {
            this.innerModuleInstantiation(realm, moduleRecord, stack, 0);
        }
        catch (GraalJSException e) {
            for (JSModuleRecord m : stack) {
                assert (m.getStatus() == JSModuleRecord.Status.Linking);
                m.setUninstantiated();
            }
            assert (moduleRecord.getStatus() == JSModuleRecord.Status.Unlinked);
            throw e;
        }
        assert (moduleRecord.getStatus() == JSModuleRecord.Status.Linked || moduleRecord.getStatus() == JSModuleRecord.Status.EvaluatingAsync || moduleRecord.getStatus() == JSModuleRecord.Status.Evaluated);
        assert (stack.isEmpty());
    }

    private int innerModuleInstantiation(JSRealm realm, JSModuleRecord moduleRecord, Deque<JSModuleRecord> stack, int index0) {
        int index;
        block8: {
            JSModuleRecord requiredModule;
            index = index0;
            if (moduleRecord.getStatus() == JSModuleRecord.Status.Linking || moduleRecord.getStatus() == JSModuleRecord.Status.Linked || moduleRecord.getStatus() == JSModuleRecord.Status.EvaluatingAsync || moduleRecord.getStatus() == JSModuleRecord.Status.Evaluated) {
                return index;
            }
            assert (moduleRecord.getStatus() == JSModuleRecord.Status.Unlinked);
            moduleRecord.setStatus(JSModuleRecord.Status.Linking);
            moduleRecord.setDFSIndex(index);
            moduleRecord.setDFSAncestorIndex(index);
            ++index;
            stack.push(moduleRecord);
            Module module = moduleRecord.getModule();
            for (Module.ModuleRequest requestedModule : module.getRequestedModules()) {
                JSModuleRecord requiredModule2 = GraalJSEvaluator.hostResolveImportedModule(moduleRecord, requestedModule);
                index = this.innerModuleInstantiation(realm, requiredModule2, stack, index);
                assert (requiredModule2.getStatus() == JSModuleRecord.Status.Linking || requiredModule2.getStatus() == JSModuleRecord.Status.Linked || requiredModule2.getStatus() == JSModuleRecord.Status.EvaluatingAsync || requiredModule2.getStatus() == JSModuleRecord.Status.Evaluated) : requiredModule2.getStatus();
                assert (requiredModule2.getStatus() == JSModuleRecord.Status.Linking == stack.contains(requiredModule2));
                if (requiredModule2.getStatus() != JSModuleRecord.Status.Linking) continue;
                moduleRecord.setDFSAncestorIndex(Math.min(moduleRecord.getDFSAncestorIndex(), requiredModule2.getDFSAncestorIndex()));
            }
            this.moduleInitializeEnvironment(realm, moduleRecord);
            assert (GraalJSEvaluator.occursExactlyOnce(moduleRecord, stack));
            assert (moduleRecord.getDFSAncestorIndex() <= moduleRecord.getDFSIndex());
            if (moduleRecord.getDFSAncestorIndex() != moduleRecord.getDFSIndex()) break block8;
            do {
                requiredModule = stack.pop();
                requiredModule.setStatus(JSModuleRecord.Status.Linked);
            } while (!requiredModule.equals(moduleRecord));
        }
        return index;
    }

    private void moduleInitializeEnvironment(JSRealm realm, JSModuleRecord moduleRecord) {
        assert (moduleRecord.getStatus() == JSModuleRecord.Status.Linking);
        Module module = moduleRecord.getModule();
        for (Module.ExportEntry exportEntry : module.getIndirectExportEntries()) {
            ExportResolution resolution = this.resolveExport(moduleRecord, exportEntry.getExportName());
            if (!resolution.isNull() && !resolution.isAmbiguous()) continue;
            throw Errors.createSyntaxError("Could not resolve indirect export entry");
        }
        DynamicObject moduleFunction = JSFunction.create(realm, moduleRecord.getFunctionData());
        Object[] arguments = JSArguments.create((Object)Undefined.instance, moduleFunction, moduleRecord);
        JSFunction.getConstructTarget(moduleFunction).call(arguments);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object moduleEvaluation(JSRealm realm, JSModuleRecord moduleRecord) {
        JSModuleRecord module = moduleRecord;
        ArrayDeque<JSModuleRecord> stack = new ArrayDeque<JSModuleRecord>(4);
        if (realm.getContext().isOptionTopLevelAwait()) {
            assert (module.getStatus() == JSModuleRecord.Status.Linked || module.getStatus() == JSModuleRecord.Status.EvaluatingAsync || module.getStatus() == JSModuleRecord.Status.Evaluated);
            if (module.getStatus() == JSModuleRecord.Status.EvaluatingAsync || module.getStatus() == JSModuleRecord.Status.Evaluated) {
                module = module.getCycleRoot();
            }
            if (module.getTopLevelCapability() != null) {
                return module.getTopLevelCapability().getPromise();
            }
            PromiseCapabilityRecord capability = NewPromiseCapabilityNode.createDefault(realm);
            module.setTopLevelCapability(capability);
            try {
                this.innerModuleEvaluation(realm, module, stack, 0);
                assert (module.getStatus() == JSModuleRecord.Status.EvaluatingAsync || module.getStatus() == JSModuleRecord.Status.Evaluated);
                assert (module.getEvaluationError() == null);
                if (!module.isAsyncEvaluation()) {
                    assert (module.getStatus() == JSModuleRecord.Status.Evaluated);
                    JSFunction.call(JSArguments.create((Object)Undefined.instance, capability.getResolve(), new Object[]{Undefined.instance}));
                }
                assert (stack.isEmpty());
            }
            catch (Throwable e) {
                if (TryCatchNode.shouldCatch(e)) {
                    for (JSModuleRecord m : stack) {
                        assert (m.getStatus() == JSModuleRecord.Status.Evaluating);
                        m.setStatus(JSModuleRecord.Status.Evaluated);
                        m.setEvaluationError(e);
                    }
                    assert (module.getStatus() == JSModuleRecord.Status.Evaluated && module.getEvaluationError() == e);
                    throw e;
                }
                throw e;
            }
            return capability.getPromise();
        }
        try {
            this.innerModuleEvaluation(realm, module, stack, 0);
        }
        catch (Throwable e) {
            if (TryCatchNode.shouldCatch(e)) {
                for (JSModuleRecord m : stack) {
                    assert (m.getStatus() == JSModuleRecord.Status.Evaluating);
                    m.setStatus(JSModuleRecord.Status.Evaluated);
                    m.setEvaluationError(e);
                }
                assert (module.getStatus() == JSModuleRecord.Status.Evaluated && module.getEvaluationError() == e);
            }
            throw e;
        }
        assert (module.getStatus() == JSModuleRecord.Status.EvaluatingAsync || module.getStatus() == JSModuleRecord.Status.Evaluated);
        assert (module.getEvaluationError() == null);
        assert (stack.isEmpty());
        Object result = module.getExecutionResult();
        return result == null ? Undefined.instance : result;
    }

    @CompilerDirectives.TruffleBoundary
    private int innerModuleEvaluation(JSRealm realm, JSModuleRecord moduleRecord, Deque<JSModuleRecord> stack, int index0) {
        int index;
        block20: {
            JSModuleRecord requiredModule;
            index = index0;
            if (moduleRecord.getStatus() == JSModuleRecord.Status.EvaluatingAsync || moduleRecord.getStatus() == JSModuleRecord.Status.Evaluated) {
                if (moduleRecord.getEvaluationError() == null) {
                    return index;
                }
                throw JSRuntime.rethrow(moduleRecord.getEvaluationError());
            }
            if (moduleRecord.getStatus() == JSModuleRecord.Status.Evaluating) {
                return index;
            }
            assert (moduleRecord.getStatus() == JSModuleRecord.Status.Linked);
            moduleRecord.setStatus(JSModuleRecord.Status.Evaluating);
            moduleRecord.setDFSIndex(index);
            moduleRecord.setDFSAncestorIndex(index);
            moduleRecord.setPendingAsyncDependencies(0);
            moduleRecord.initAsyncParentModules();
            ++index;
            stack.push(moduleRecord);
            Module module = moduleRecord.getModule();
            for (Module.ModuleRequest requestedModule : module.getRequestedModules()) {
                JSModuleRecord requiredModule2 = GraalJSEvaluator.hostResolveImportedModule(moduleRecord, requestedModule);
                index = this.innerModuleEvaluation(realm, requiredModule2, stack, index);
                assert (requiredModule2.getStatus() == JSModuleRecord.Status.Evaluating || requiredModule2.getStatus() == JSModuleRecord.Status.EvaluatingAsync || requiredModule2.getStatus() == JSModuleRecord.Status.Evaluated) : requiredModule2.getStatus();
                assert (requiredModule2.getStatus() == JSModuleRecord.Status.Evaluating == stack.contains(requiredModule2));
                if (requiredModule2.getStatus() == JSModuleRecord.Status.Evaluating) {
                    moduleRecord.setDFSAncestorIndex(Math.min(moduleRecord.getDFSAncestorIndex(), requiredModule2.getDFSAncestorIndex()));
                } else {
                    requiredModule2 = requiredModule2.getCycleRoot();
                    assert (requiredModule2.getStatus() == JSModuleRecord.Status.EvaluatingAsync || requiredModule2.getStatus() == JSModuleRecord.Status.Evaluated);
                    if (requiredModule2.getEvaluationError() != null) {
                        throw JSRuntime.rethrow(moduleRecord.getEvaluationError());
                    }
                }
                if (!requiredModule2.isAsyncEvaluation()) continue;
                moduleRecord.incPendingAsyncDependencies();
                requiredModule2.appendAsyncParentModules(moduleRecord);
            }
            if (moduleRecord.getPendingAsyncDependencies() > 0 || moduleRecord.hasTLA()) {
                assert (!moduleRecord.isAsyncEvaluation());
                moduleRecord.setAsyncEvaluatingOrder(realm.nextAsyncEvaluationOrder());
                if (moduleRecord.getPendingAsyncDependencies() == 0) {
                    GraalJSEvaluator.moduleAsyncExecution(realm, moduleRecord);
                }
            } else {
                Object result = GraalJSEvaluator.moduleExecution(realm, moduleRecord, null);
                moduleRecord.setExecutionResult(result);
            }
            assert (GraalJSEvaluator.occursExactlyOnce(moduleRecord, stack));
            assert (moduleRecord.getDFSAncestorIndex() <= moduleRecord.getDFSIndex());
            if (moduleRecord.getDFSAncestorIndex() != moduleRecord.getDFSIndex()) break block20;
            do {
                if (!(requiredModule = stack.pop()).isAsyncEvaluation()) {
                    requiredModule.setStatus(JSModuleRecord.Status.Evaluated);
                } else {
                    requiredModule.setStatus(JSModuleRecord.Status.EvaluatingAsync);
                }
                requiredModule.setCycleRoot(moduleRecord);
            } while (!requiredModule.equals(moduleRecord));
        }
        return index;
    }

    @CompilerDirectives.TruffleBoundary
    private static void moduleAsyncExecution(JSRealm realm, JSModuleRecord module) {
        assert (module.getStatus() == JSModuleRecord.Status.Evaluating || module.getStatus() == JSModuleRecord.Status.EvaluatingAsync);
        assert (module.hasTLA());
        PromiseCapabilityRecord capability = NewPromiseCapabilityNode.createDefault(realm);
        DynamicObject onFulfilled = GraalJSEvaluator.createCallAsyncModuleFulfilled(realm, module);
        DynamicObject onRejected = GraalJSEvaluator.createCallAsyncModuleRejected(realm, module);
        Object then = JSObject.get(capability.getPromise(), "then");
        JSFunction.call(JSArguments.create(capability.getPromise(), then, onFulfilled, onRejected));
        GraalJSEvaluator.moduleExecution(realm, module, capability);
    }

    @CompilerDirectives.TruffleBoundary
    private static DynamicObject createCallAsyncModuleFulfilled(JSRealm realm, JSModuleRecord module) {
        JSFunctionData functionData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncModuleExecutionFulfilled, c -> GraalJSEvaluator.createCallAsyncModuleFulfilledImpl(c));
        DynamicObject function = JSFunction.create(realm, functionData);
        JSObjectUtil.putHiddenProperty(function, STORE_MODULE_KEY, module);
        return function;
    }

    private static JSFunctionData createCallAsyncModuleFulfilledImpl(JSContext context) {
        class AsyncModuleFulfilledRoot
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode argumentNode = AccessIndexedArgumentNode.create(0);
            @Node.Child
            private PropertyGetNode getModule = PropertyGetNode.createGetHidden(GraalJSEvaluator.access$300(), this.val$context);
            final /* synthetic */ JSContext val$context;

            AsyncModuleFulfilledRoot(JSContext jSContext) {
                this.val$context = jSContext;
            }

            public Object execute(VirtualFrame frame) {
                Object dynamicImportResolutionResult = this.argumentNode.execute(frame);
                Object module = this.getModule.getValue(JSArguments.getFunctionObject(frame.getArguments()));
                return GraalJSEvaluator.asyncModuleExecutionFulfilled(this.getRealm(), (JSModuleRecord)module, dynamicImportResolutionResult);
            }
        }
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new AsyncModuleFulfilledRoot(context));
        return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 1, "");
    }

    @CompilerDirectives.TruffleBoundary
    private static DynamicObject createCallAsyncModuleRejected(JSRealm realm, JSModuleRecord module) {
        JSFunctionData functionData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncModuleExecutionRejected, c -> GraalJSEvaluator.createCallAsyncModuleRejectedImpl(c));
        DynamicObject function = JSFunction.create(realm, functionData);
        JSObjectUtil.putHiddenProperty(function, STORE_MODULE_KEY, module);
        return function;
    }

    private static JSFunctionData createCallAsyncModuleRejectedImpl(JSContext context) {
        class AsyncModuleExecutionRejectedRoot
        extends JavaScriptRootNode {
            @Node.Child
            private PropertyGetNode getModule;
            @Node.Child
            private PropertyGetNode getRejectionError;
            final /* synthetic */ JSContext val$context;

            AsyncModuleExecutionRejectedRoot(JSContext jSContext) {
                this.val$context = jSContext;
                this.getModule = PropertyGetNode.createGetHidden(STORE_MODULE_KEY, this.val$context);
                this.getRejectionError = PropertyGetNode.createGetHidden(JSPromise.PROMISE_RESULT, this.val$context);
            }

            public Object execute(VirtualFrame frame) {
                JSModuleRecord module = (JSModuleRecord)this.getModule.getValue(JSArguments.getFunctionObject(frame.getArguments()));
                Object resolvedPromise = module.getExecutionContinuation();
                assert (JSPromise.isJSPromise(resolvedPromise));
                assert (JSPromise.isRejected((DynamicObject)resolvedPromise));
                Object reaction = this.getRejectionError.getValue(resolvedPromise);
                return GraalJSEvaluator.asyncModuleExecutionRejected(this.getRealm(), module, reaction);
            }
        }
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new AsyncModuleExecutionRejectedRoot(context));
        return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 1, "");
    }

    private static void gatherAvailableAncestors(JSModuleRecord module, Set<JSModuleRecord> execList) {
        for (JSModuleRecord m : module.getAsyncParentModules()) {
            if (execList.contains(m) || m.getCycleRoot().getEvaluationError() != null) continue;
            assert (m.getStatus() == JSModuleRecord.Status.EvaluatingAsync);
            assert (m.getEvaluationError() == null);
            assert (m.isAsyncEvaluation());
            assert (m.getPendingAsyncDependencies() > 0);
            m.decPendingAsyncDependencies();
            if (m.getPendingAsyncDependencies() != 0) continue;
            execList.add(m);
            if (m.hasTLA()) continue;
            GraalJSEvaluator.gatherAvailableAncestors(m, execList);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static Object asyncModuleExecutionFulfilled(JSRealm realm, JSModuleRecord module, Object dynamicImportResolutionResult) {
        if (module.getStatus() == JSModuleRecord.Status.Evaluated) {
            assert (module.getEvaluationError() != null);
            return Undefined.instance;
        }
        assert (module.getStatus() == JSModuleRecord.Status.EvaluatingAsync);
        assert (module.isAsyncEvaluation());
        assert (module.getEvaluationError() == null);
        module.setStatus(JSModuleRecord.Status.Evaluated);
        if (module.getTopLevelCapability() != null) {
            assert (module.getCycleRoot() == module);
            JSFunction.call(JSArguments.create((Object)Undefined.instance, module.getTopLevelCapability().getResolve(), dynamicImportResolutionResult));
        }
        TreeSet<JSModuleRecord> execList = new TreeSet<JSModuleRecord>(new Comparator<JSModuleRecord>(){

            @Override
            public int compare(JSModuleRecord o1, JSModuleRecord o2) {
                return Long.compare(o1.getAsyncEvaluatingOrder(), o2.getAsyncEvaluatingOrder());
            }
        });
        GraalJSEvaluator.gatherAvailableAncestors(module, execList);
        for (JSModuleRecord m : execList) {
            if (m.getStatus() == JSModuleRecord.Status.Evaluated) {
                assert (m.getEvaluationError() != null);
                continue;
            }
            if (m.hasTLA()) {
                GraalJSEvaluator.moduleAsyncExecution(realm, m);
                continue;
            }
            try {
                GraalJSEvaluator.moduleExecution(realm, m, null);
                m.setStatus(JSModuleRecord.Status.Evaluated);
                if (m.getTopLevelCapability() == null) continue;
                assert (m.getCycleRoot() == m);
                JSFunction.call(JSArguments.create((Object)Undefined.instance, m.getTopLevelCapability().getResolve(), dynamicImportResolutionResult));
            }
            catch (Exception e) {
                GraalJSEvaluator.asyncModuleExecutionRejected(realm, m, e);
            }
        }
        return Undefined.instance;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object asyncModuleExecutionRejected(JSRealm realm, JSModuleRecord module, Object error) {
        assert (error != null) : "Cannot reject a module creation with null error";
        if (module.getStatus() == JSModuleRecord.Status.Evaluated) {
            assert (module.getEvaluationError() != null);
            return Undefined.instance;
        }
        assert (module.getStatus() == JSModuleRecord.Status.EvaluatingAsync);
        assert (module.isAsyncEvaluation());
        assert (module.getEvaluationError() == null);
        module.setEvaluationError((Throwable)((Object)JSRuntime.getException(error)));
        module.setStatus(JSModuleRecord.Status.Evaluated);
        for (JSModuleRecord m : module.getAsyncParentModules()) {
            GraalJSEvaluator.asyncModuleExecutionRejected(realm, m, error);
        }
        if (module.getTopLevelCapability() != null) {
            assert (module.getCycleRoot() == module);
            JSFunction.call((DynamicObject)module.getTopLevelCapability().getReject(), (Object)Undefined.instance, new Object[]{error});
        }
        return Undefined.instance;
    }

    private static Object moduleExecution(JSRealm realm, JSModuleRecord moduleRecord, PromiseCapabilityRecord capability) {
        if (!moduleRecord.hasTLA()) {
            assert (capability == null);
            return JSFunction.call(JSArguments.create((Object)Undefined.instance, JSFunction.create(realm, moduleRecord.getFunctionData()), moduleRecord));
        }
        Object asyncFunctionResultPromise = JSFunction.call(JSArguments.create((Object)Undefined.instance, JSFunction.create(realm, moduleRecord.getFunctionData()), moduleRecord, capability));
        moduleRecord.setExecutionContinuation(asyncFunctionResultPromise);
        return asyncFunctionResultPromise;
    }

    private static boolean occursExactlyOnce(JSModuleRecord moduleRecord, Collection<JSModuleRecord> stack) {
        return stack.stream().filter(moduleRecord::equals).count() == 1L;
    }

    @Override
    public ScriptNode parseScript(JSContext context, Source source, ByteBuffer binary) {
        return ScriptNode.fromFunctionRoot((FunctionRootNode)new BinarySnapshotProvider(binary).apply(NodeFactory.getInstance(context), context, source));
    }

    @Override
    public ScriptNode parseScript(JSContext context, Source source, SnapshotProvider snapshotProvider) {
        return ScriptNode.fromFunctionRoot((FunctionRootNode)snapshotProvider.apply(NodeFactory.getInstance(context), context, source));
    }

    @Override
    public JavaScriptNode parseInlineScript(JSContext context, Source source, MaterializedFrame lexicalContextFrame, boolean isStrict, Node locationNode) {
        DebugEnvironment env;
        try {
            Object scope = NodeLibrary.getUncached().getScope((Object)locationNode, (Frame)lexicalContextFrame, true);
            env = new DebugEnvironment(null, NodeFactory.getInstance(context), context, scope);
        }
        catch (UnsupportedMessageException e) {
            Object scope = null;
            env = null;
        }
        ScriptNode script = JavaScriptTranslator.translateInlineScript(NodeFactory.getInstance(context), context, env, source, isStrict);
        return GraalJSEvaluator.createInlineScriptCallNode(context, script.getFunctionData(), script.getCallTarget(), locationNode);
    }

    private static JavaScriptNode createInlineScriptCallNode(final JSContext context, final JSFunctionData functionData, final RootCallTarget callTarget, final Node locationNode) {
        return new JavaScriptNode(){
            @Node.Child
            private DirectCallNode callNode;
            @Node.Child
            private PropertySetNode setScopeNode;
            @Node.Child
            private NodeLibrary nodeLibrary;
            {
                this.callNode = DirectCallNode.create((CallTarget)callTarget);
                this.setScopeNode = PropertySetNode.createSetHidden(JSFunction.DEBUG_SCOPE_ID, context);
                this.nodeLibrary = (NodeLibrary)NodeLibrary.getFactory().createDispatched(5);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                DynamicObject closure = JSFunction.create(this.getRealm(), functionData);
                try {
                    Object scope = this.nodeLibrary.getScope((Object)locationNode, (Frame)frame, true);
                    this.setScopeNode.setValue(closure, scope);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
                return this.callNode.call(JSArguments.createZeroArg(JSFrameUtil.getThisObj((Frame)frame), closure));
            }
        };
    }

    @Override
    public Expression parseExpression(JSContext context, String sourceString) {
        return GraalJSParserHelper.parseExpression(context, Source.newBuilder((String)"js", (CharSequence)sourceString, (String)"<unknown>").build(), context.getParserOptions());
    }

    private final class ModuleScriptRoot
    extends JavaScriptRootNode {
        private final JSContext context;
        private final JSModuleData parsedModule;
        private final Source source;
        @Node.Child
        private PerformPromiseThenNode performPromiseThenNode;

        private ModuleScriptRoot(JSContext context, JSModuleData parsedModule, Source source) {
            super(context.getLanguage(), JSBuiltin.createSourceSection(), null);
            this.context = context;
            this.parsedModule = parsedModule;
            this.source = source;
            this.performPromiseThenNode = PerformPromiseThenNode.create(context);
        }

        public Object execute(VirtualFrame frame) {
            JSRealm realm = JSFunction.getRealm(JSFrameUtil.getFunctionObject((Frame)frame));
            return this.evalModule(realm);
        }

        @CompilerDirectives.TruffleBoundary
        private Object evalModule(JSRealm realm) {
            JSModuleRecord moduleRecord = realm.getModuleLoader().loadModule(this.source, this.parsedModule);
            GraalJSEvaluator.this.moduleInstantiation(realm, moduleRecord);
            Object promise = GraalJSEvaluator.this.moduleEvaluation(realm, moduleRecord);
            if (this.context.isOptionTopLevelAwait() && JSPromise.isJSPromise(promise)) {
                DynamicObject onRejected = GraalJSEvaluator.createTopLevelAwaitReject(this.context, realm);
                DynamicObject onAccepted = GraalJSEvaluator.createTopLevelAwaitResolve(this.context, realm);
                this.performPromiseThenNode.execute((DynamicObject)promise, onAccepted, onRejected, null);
            }
            if (realm.getContext().getContextOptions().isEsmEvalReturnsExports()) {
                DynamicObject moduleNamespace = GraalJSEvaluator.this.getModuleNamespace(moduleRecord);
                assert (moduleNamespace != null);
                return moduleNamespace;
            }
            assert (promise != null);
            return promise;
        }

        JSModuleData getModuleData() {
            return this.parsedModule;
        }
    }
}

