/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.table;

import com.paterva.maltego.util.ui.table.EditableTableColumnSelector;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.table.TableColumn;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.etable.TableColumnSelector;

public class ETableColumnSelectionDecorator {
    public void makeSelectable(ETable table, String[] columnNames) {
        boolean[] visible = new boolean[columnNames.length];
        Arrays.fill(visible, true);
        this.makeSelectable(table, columnNames, visible);
    }

    public void makeSelectable(ETable table, String[] columnNames, String[] displayNames) {
        boolean[] visible = new boolean[columnNames.length];
        Arrays.fill(visible, true);
        this.makeSelectable(table, columnNames, visible, displayNames);
    }

    public void makeSelectable(ETable table, String[] columnNames, boolean[] visible) {
        this.makeSelectable(table, columnNames, visible, columnNames);
    }

    public void makeSelectable(ETable table, String[] columnNames, boolean[] visible, String[] displayNames) {
        ETableColumnModel model = (ETableColumnModel)table.getColumnModel();
        if (columnNames.length != visible.length || columnNames.length != displayNames.length) {
            throw new IllegalArgumentException("Column indices, visibility and display name arrays must be of equal length.");
        }
        for (int i = 0; i < columnNames.length; ++i) {
            if (displayNames[i] != null) continue;
            displayNames[i] = columnNames[i];
        }
        String[] allColumns = new String[model.getColumnCount()];
        int index = 0;
        Enumeration<TableColumn> columnEnum = table.getColumnModel().getColumns();
        while (columnEnum.hasMoreElements()) {
            String colName = columnEnum.nextElement().getHeaderValue().toString();
            allColumns[index++] = colName;
        }
        for (int i = 0; i < columnNames.length; ++i) {
            String colName = columnNames[i];
            ETableColumn col = (ETableColumn)model.getColumn(model.getColumnIndex((Object)colName));
            columnNames[i] = col.getIdentifier().toString();
            model.setColumnHidden((TableColumn)col, !visible[i]);
        }
        table.setColumnSelector((TableColumnSelector)new EditableTableColumnSelector(table, allColumns, columnNames, displayNames));
    }
}

