/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.wizard.im;

import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.importexport.DiscoverService;
import com.paterva.maltego.importexport.nodes.AllConfigsNode;
import com.paterva.maltego.importexport.previous.PreviousVersion;
import com.paterva.maltego.importexport.previous.PreviousVersionsController;
import com.paterva.maltego.importexport.wizard.ItemSelectionController;
import com.paterva.maltego.importexport.wizard.im.ImportDiscoverController;
import com.paterva.maltego.importexport.wizard.im.ImportFileController;
import com.paterva.maltego.importexport.wizard.im.ImportProgressController;
import com.paterva.maltego.importexport.wizard.im.ImportProgressController2;
import com.paterva.maltego.util.ui.dialog.ArrayWizardIterator;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import java.util.TreeMap;
import org.openide.WizardDescriptor;
import org.openide.util.NbPreferences;

public class ImportWizard {
    private static final String WIZARD_TITLE = "Import Wizard";

    public static WizardDescriptor create(ConfigImporter[] importers, Map<String, String> descriptionAndIcons) {
        return ImportWizard.create(importers, null, descriptionAndIcons);
    }

    public static WizardDescriptor create(ConfigImporter[] importers, File file, Map<String, String> descriptionAndIcons) {
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{new ImportFileController(), new ItemSelectionController(), new ImportProgressController()};
        WizardUtilities.updatePanels((WizardDescriptor.Panel[])panels);
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)new ArrayWizardIterator(panels));
        wizardDescriptor.setTitleFormat(new MessageFormat("Import Wizard - {0}"));
        wizardDescriptor.setTitle(WIZARD_TITLE);
        wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
        for (Map.Entry<String, String> entrySet : descriptionAndIcons.entrySet()) {
            wizardDescriptor.putProperty(entrySet.getKey(), (Object)entrySet.getValue());
        }
        wizardDescriptor.putProperty("importers", (Object)importers);
        if (file != null) {
            wizardDescriptor.putProperty("selectedFile", (Object)file);
        } else {
            wizardDescriptor.putProperty("browseDir", (Object)NbPreferences.root().get("browseDir", ""));
        }
        return wizardDescriptor;
    }

    public static WizardDescriptor create(TreeMap<Config, ConfigImporter> configsMap, Map<String, String> descriptionAndIcons) {
        WizardDescriptor.Panel[] panelArray;
        boolean canDiscover;
        boolean bl = canDiscover = DiscoverService.getDefault() != null;
        if (canDiscover) {
            WizardDescriptor.Panel[] panelArray2 = new WizardDescriptor.Panel[3];
            panelArray2[0] = new ItemSelectionController();
            panelArray2[1] = new ImportDiscoverController();
            panelArray = panelArray2;
            panelArray2[2] = new ImportProgressController2();
        } else {
            WizardDescriptor.Panel[] panelArray3 = new WizardDescriptor.Panel[2];
            panelArray3[0] = new ItemSelectionController();
            panelArray = panelArray3;
            panelArray3[1] = new ImportProgressController2();
        }
        WizardDescriptor.Panel[] panels = panelArray;
        WizardUtilities.updatePanels((WizardDescriptor.Panel[])panels);
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)new ArrayWizardIterator(panels));
        wizardDescriptor.setTitleFormat(new MessageFormat("Import Wizard - {0}"));
        wizardDescriptor.setTitle(WIZARD_TITLE);
        wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
        for (Map.Entry<String, String> entrySet : descriptionAndIcons.entrySet()) {
            wizardDescriptor.putProperty(entrySet.getKey(), (Object)entrySet.getValue());
        }
        ConfigImporter[] importers = configsMap.values().toArray(new ConfigImporter[0]);
        wizardDescriptor.putProperty("importers", (Object)importers);
        wizardDescriptor.putProperty("configsMap", configsMap);
        wizardDescriptor.putProperty("allConfigs", (Object)new AllConfigsNode(configsMap.keySet(), true));
        return wizardDescriptor;
    }

    public static WizardDescriptor createPreviousImport(ConfigImporter[] importers, PreviousVersion[] versions, Map<String, String> descriptionAndIcons) {
        WizardDescriptor.Panel[] panelArray;
        boolean canDiscover;
        boolean bl = canDiscover = DiscoverService.getDefault() != null;
        if (canDiscover) {
            WizardDescriptor.Panel[] panelArray2 = new WizardDescriptor.Panel[4];
            panelArray2[0] = new PreviousVersionsController();
            panelArray2[1] = new ItemSelectionController();
            panelArray2[2] = new ImportDiscoverController();
            panelArray = panelArray2;
            panelArray2[3] = new ImportProgressController2();
        } else {
            WizardDescriptor.Panel[] panelArray3 = new WizardDescriptor.Panel[3];
            panelArray3[0] = new PreviousVersionsController();
            panelArray3[1] = new ItemSelectionController();
            panelArray = panelArray3;
            panelArray3[2] = new ImportProgressController2();
        }
        WizardDescriptor.Panel[] panels = panelArray;
        WizardUtilities.updatePanels((WizardDescriptor.Panel[])panels);
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)new ArrayWizardIterator(panels));
        wizardDescriptor.setTitleFormat(new MessageFormat("Import Wizard - {0}"));
        wizardDescriptor.setTitle(WIZARD_TITLE);
        wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
        for (Map.Entry<String, String> entrySet : descriptionAndIcons.entrySet()) {
            wizardDescriptor.putProperty(entrySet.getKey(), (Object)entrySet.getValue());
        }
        wizardDescriptor.putProperty("importers", (Object)importers);
        wizardDescriptor.putProperty("previousVersions", (Object)versions);
        return wizardDescriptor;
    }
}

