/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tx.inputs.global.serialize;

import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.repository.serializer.TransformDescriptorSerializer;
import com.paterva.maltego.transform.repository.serializer.TransformPropertyStub;
import com.paterva.maltego.tx.inputs.global.registry.GlobalTransformInput;
import com.paterva.maltego.tx.inputs.global.serialize.GlobalTransformInputStub;
import com.paterva.maltego.util.XmlSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GlobalTransformInputSerializer {
    public GlobalTransformInput read(InputStream inputStream) throws IOException {
        XmlSerializer serializer = new XmlSerializer();
        GlobalTransformInputStub stub = (GlobalTransformInputStub)serializer.read(GlobalTransformInputStub.class, inputStream);
        return this.translate(stub);
    }

    public void write(GlobalTransformInput input, OutputStream os) throws IOException {
        XmlSerializer serializer = new XmlSerializer();
        GlobalTransformInputStub stub = this.translate(input);
        serializer.write((Object)stub, os);
    }

    private GlobalTransformInput translate(GlobalTransformInputStub stub) throws IOException {
        TransformPropertyStub propertyStub = stub.getProperty();
        TransformPropertyDescriptor property = TransformDescriptorSerializer.translate((TransformPropertyStub)propertyStub);
        String valueStr = stub.getValue();
        Object value = property.getTypeDescriptor().convert(valueStr);
        return new GlobalTransformInput(property, value);
    }

    private GlobalTransformInputStub translate(GlobalTransformInput input) throws IOException {
        TransformPropertyDescriptor property = input.getDescriptor();
        TransformPropertyStub propertyStub = TransformDescriptorSerializer.translate((TransformPropertyDescriptor)property);
        Object value = input.getValue();
        String valueStr = property.getTypeDescriptor().convert(value);
        GlobalTransformInputStub stub = new GlobalTransformInputStub();
        stub.setProperty(propertyStub);
        stub.setValue(valueStr);
        return stub;
    }
}

