/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.notifications;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.notifications.ServerNotificationDisplayer;
import com.paterva.maltego.notifications.ServerNotificationsDownloader;
import com.paterva.maltego.notifications.data.ServerNotification;
import com.paterva.maltego.util.ui.dialog.UIRunQueue;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class ServerNotificationChecker {
    private static final Logger LOG = Logger.getLogger(ServerNotificationChecker.class.getName());
    public static final String SERVER_NOTIFICATION_CHECK_TASK = "ServerNotificationCheck";

    public void checkForNotifications() {
        UIRunQueue.instance().registerAsyncTask(SERVER_NOTIFICATION_CHECK_TASK);
        Thread thread = new Thread(() -> {
            try {
                LOG.info("Checking for notifications");
                A licenseMode = LicenseManager.A().A(false);
                String accessToken = LicenseManager.A().G(licenseMode);
                if (licenseMode.D()) {
                    LOG.log(Level.FINE, "Unknown Product Plan. Skipping notification download");
                    UIRunQueue.instance().setAsyncTaskCompleted(SERVER_NOTIFICATION_CHECK_TASK);
                } else if (licenseMode.U() && accessToken == null) {
                    LOG.log(Level.FINE, "Gateway authentication has not completed. Skipping notification download");
                    UIRunQueue.instance().setAsyncTaskCompleted(SERVER_NOTIFICATION_CHECK_TASK);
                } else {
                    ServerNotificationsDownloader downloader = new ServerNotificationsDownloader();
                    List<ServerNotification> notifications = downloader.download();
                    LOG.log(Level.INFO, "{0} notification(s)", notifications.size());
                    if (notifications.isEmpty()) {
                        UIRunQueue.instance().setAsyncTaskCompleted(SERVER_NOTIFICATION_CHECK_TASK);
                    } else {
                        UIRunQueue.instance().queue(100, "Server Notification Displayer", () -> {
                            ServerNotificationDisplayer displayer = new ServerNotificationDisplayer();
                            displayer.show(notifications);
                            UIRunQueue.instance().setAsyncTaskCompleted(SERVER_NOTIFICATION_CHECK_TASK);
                        });
                    }
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }, "Notifications Download");
        thread.setDaemon(true);
        thread.start();
    }
}

