/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph;

import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.graph.GraphSnapshot;
import com.paterva.maltego.collab.session.PayloadHelper;
import java.util.Map;

public class StartGraphMessage {
    private GraphSnapshot _snapshot;

    protected StartGraphMessage(GraphSnapshot snapshot) {
        this._snapshot = snapshot;
    }

    public static StartGraphMessage create(GraphSnapshot snapshot) {
        return new StartGraphMessage(snapshot);
    }

    public String getEntitySpecs() {
        return this._snapshot.getEntitySpecs();
    }

    public String getLinkSpecs() {
        return this._snapshot.getLinkSpecs();
    }

    public String getTransactions() {
        return this._snapshot.getTransactions();
    }

    public String getIcons() {
        return this._snapshot.getIcons();
    }

    public String getLayoutSettings() {
        return this._snapshot.getLayoutSettings();
    }

    public String getCollectionSettings() {
        return this._snapshot.getCollectionSettings();
    }

    public static StartGraphMessage parse(String xml) throws CollaborationException {
        Map<String, String> payloads = PayloadHelper.getBodies(xml);
        String graph = PayloadHelper.getBody("graph", payloads.get("graph"), null, false);
        String especs = payloads.get("especs");
        String lspecs = payloads.get("lspecs");
        String icons = payloads.get("icons");
        String layouts = payloads.get("layouts");
        String collectionSettings = payloads.get("collect");
        return new StartGraphMessage(new GraphSnapshot(icons, especs, lspecs, graph, layouts, collectionSettings));
    }

    public String toXml() {
        return PayloadHelper.createPayload("start", this.toString(this._snapshot), false);
    }

    private String toString(GraphSnapshot snapshot) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(snapshot.getIcons());
        buffer.append(snapshot.getEntitySpecs());
        buffer.append(snapshot.getLinkSpecs());
        buffer.append(PayloadHelper.createPayload("graph", snapshot.getTransactions(), false));
        buffer.append(snapshot.getLayoutSettings());
        buffer.append(snapshot.getCollectionSettings());
        return buffer.toString();
    }
}

