/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.propertyview;

import com.paterva.maltego.core.EntityUpdate;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkUpdate;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.editing.AddPropertyFormController;
import com.paterva.maltego.ui.graph.GraphUser;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.actions.TopGraphSelectionContextAction;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransactions;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import yguard.A.A.D;
import yguard.A.J.SA;

public class AddDynamicPropertyAction
extends TopGraphSelectionContextAction {
    protected void actionPerformed(GraphView graphView) {
        EditDialogDescriptor vd = new EditDialogDescriptor("Add New Property", (WizardDescriptor.Panel)new AddPropertyFormController());
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)vd) == EditDialogDescriptor.OK_OPTION) {
            String name = (String)vd.getProperty("uniqueName");
            TypeDescriptor type = (TypeDescriptor)vd.getProperty("typeDescriptor");
            String displayName = (String)vd.getProperty("displayName");
            PropertyDescriptor pd = new PropertyDescriptor(type.getType(), name, displayName);
            SA viewGraph = graphView.getViewGraph();
            GraphID graphID = GraphIDProvider.forGraph((SA)viewGraph);
            GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
            String user = GraphUser.getUser((D)viewGraph);
            Set entities = GraphStoreHelper.getMaltegoEntities((D)viewGraph, (Collection)selection.getSelectedModelEntities());
            Map entityAddPropertyUpdates = GraphTransactionHelper.createEntityUpdates((Collection)entities);
            Map entitySetPropertyUpdates = GraphTransactionHelper.createEntityUpdates((Collection)entities);
            for (Map.Entry entry : entityAddPropertyUpdates.entrySet()) {
                ((EntityUpdate)entry.getKey()).addProperty(pd);
            }
            for (Map.Entry entry : entitySetPropertyUpdates.entrySet()) {
                EntityUpdate entityUpdate = (EntityUpdate)entry.getKey();
                entityUpdate.addProperty(pd);
                entityUpdate.setValue(pd, type.getDefaultValue());
                ModifiedHelper.addToUpdate((String)user, (MaltegoEntity)((MaltegoEntity)entry.getValue()), (EntityUpdate)entityUpdate);
            }
            Set links = GraphStoreHelper.getMaltegoLinks((D)viewGraph, (Collection)selection.getSelectedModelLinks());
            Map linkAddPropertyUpdates = GraphTransactionHelper.createLinkUpdates((Collection)links);
            Map linkSetPropertyUpdates = GraphTransactionHelper.createLinkUpdates((Collection)links);
            for (Map.Entry entry : linkAddPropertyUpdates.entrySet()) {
                ((LinkUpdate)entry.getKey()).addProperty(pd);
            }
            for (Map.Entry entry : linkAddPropertyUpdates.entrySet()) {
                LinkUpdate linkUpdate = (LinkUpdate)entry.getKey();
                linkUpdate.addProperty(pd);
                linkUpdate.setValue(pd, type.getDefaultValue());
                ModifiedHelper.addToUpdate((String)user, (MaltegoLink)((MaltegoLink)entry.getValue()), (LinkUpdate)linkUpdate);
            }
            String description = "%s dynamic property \"" + SimilarStrings.escape((String)displayName) + "\" %s ";
            description = entities.size() > 0 ? description + GraphTransactionHelper.getDescriptionForEntities((D)viewGraph, (Collection)entities, (boolean)true) : description + GraphTransactionHelper.getDescriptionForLinks((D)viewGraph, (Collection)links, (boolean)true);
            SimilarStrings descriptions = new SimilarStrings(description, new Object[]{"Add", "to"}, new Object[]{"Remove", "from"});
            GraphTransactionBatch batch = new GraphTransactionBatch(descriptions, true, new GraphTransaction[0]);
            batch.add(GraphTransactions.addProperties(entityAddPropertyUpdates.keySet(), linkAddPropertyUpdates.keySet()));
            batch.add(GraphTransactions.updateEntitiesAndLinks(entitySetPropertyUpdates.keySet(), linkSetPropertyUpdates.keySet()));
            GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
        }
    }

    public String getName() {
        return "Add Property...";
    }

    protected String iconResource() {
        return "com/paterva/maltego/propertyview/Add.png";
    }
}

