/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing;

import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class PropertyDescriptorSet
extends AbstractSet<PropertyDescriptor>
implements PropertyDescriptorCollection {
    private Map<String, PropertyDescriptor> _list = new LinkedHashMap<String, PropertyDescriptor>();

    public PropertyDescriptorSet() {
    }

    public PropertyDescriptorSet(Collection<PropertyDescriptor> collection) {
        super.addAll(collection);
    }

    public boolean isCopy(PropertyDescriptorSet other) {
        if (other == null) {
            return false;
        }
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        if (this.size() != other.size()) {
            return false;
        }
        for (String name : this._list.keySet()) {
            if (other.contains(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(PropertyDescriptor e) {
        if (!this._list.containsKey(e.getName())) {
            this._list.put(e.getName(), e);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<PropertyDescriptor> iterator() {
        return this._list.values().iterator();
    }

    @Override
    public int size() {
        return this._list.size();
    }

    @Override
    public PropertyDescriptor get(String name) {
        return this._list.get(name);
    }

    @Override
    public boolean contains(String name) {
        return this._list.containsKey(name);
    }

    @Override
    public boolean remove(PropertyDescriptor pd) {
        return this._list.remove(pd.getName()) != null;
    }

    @Override
    public boolean remove(String name) {
        return this._list.remove(name) != null;
    }

    @Override
    public void removeAll(PropertyDescriptorCollection collection) {
        this._list.clear();
    }

    @Override
    public void addAll(PropertyDescriptorCollection collection) {
        for (PropertyDescriptor pd : collection) {
            this._list.put(pd.getName(), pd);
        }
    }

    @Override
    public boolean contains(PropertyDescriptor pd) {
        return this._list.containsKey(pd.getName());
    }
}

