/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import org.lobobrowser.html.HtmlObject;
import org.lobobrowser.html.renderer.BrokenComponent;
import org.lobobrowser.html.renderer.RUIControl;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.UIControl;

class UIControlWrapper
implements UIControl {
    private final Component component;
    private final HtmlObject htmlObject;

    public UIControlWrapper(HtmlObject ho) {
        this.htmlObject = ho;
        Component c = ho == null ? new BrokenComponent() : ho.getComponent();
        this.component = c;
    }

    @Override
    public void reset(int availWidth, int availHeight) {
        this.htmlObject.reset(availWidth, availHeight);
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public int getVAlign() {
        return 5;
    }

    @Override
    public Color getBackgroundColor() {
        return this.component.getBackground();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.component.getPreferredSize();
    }

    @Override
    public void invalidate() {
        this.component.invalidate();
    }

    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        return inSelection;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.component.setBounds(x, y, width, height);
    }

    @Override
    public void setRUIControl(RUIControl ruicontrol) {
    }

    @Override
    public void paint(Graphics g) {
        this.component.paint(g);
    }
}

