/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.Compilation;
import com.paterva.maltego.automation.CompilationException;
import com.paterva.maltego.automation.MachineCompiler;
import com.paterva.maltego.automation.MachineCompilerOptions;
import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineInput;
import com.paterva.maltego.automation.MachineInputs;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.actions.AbstractFilter;
import com.paterva.maltego.transform.descriptor.InheritedTypesProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openide.util.Lookup;

public abstract class MachineInputProvider {
    private static final Logger LOG = Logger.getLogger(MachineInputProvider.class.getName());

    public static MachineInputProvider getDefault() {
        MachineInputProvider manager = (MachineInputProvider)Lookup.getDefault().lookup(MachineInputProvider.class);
        if (manager == null) {
            manager = new NoCache();
        }
        return manager;
    }

    public abstract MachineInput getInputDescriptor(MachineDescriptor var1);

    protected MachineInput calculateConstraint(MachineDescriptor machine) {
        try {
            Compilation compilation = MachineCompiler.getDefault().compile((String)machine.getData(), MachineCompilerOptions.DEFAULT).getMain();
            Compilation.Node input = compilation.getInput();
            return this.getInput(input);
        }
        catch (CompilationException ex) {
            LOG.warning(() -> "Failed to compile machine '" + machine.getName() + "': " + ex);
            return MachineInputs.denyAll();
        }
    }

    private MachineInputTreeNode getInput(Compilation.Node node) {
        MachineInput input = node.getInputDescriptor();
        MachineInputTreeNode inputNode = new MachineInputTreeNode(input);
        if (input.continueCheck()) {
            for (Compilation.Node child : node.getChildren()) {
                inputNode.addChild(this.getInput(child));
            }
        }
        return inputNode;
    }

    public boolean isNonInputEntityTypeMachines(MachineInput machineInput) {
        return machineInput != null && machineInput.getSupportedEntityTypes().length == 0;
    }

    public boolean isLocalScope(MachineDescriptor machineDescriptor) {
        boolean localScope = false;
        try {
            Compilation compilation = MachineCompiler.getDefault().compile((String)machineDescriptor.getData(), MachineCompilerOptions.DEFAULT).getMain();
            HashMap<Compilation.Node, String> map = new HashMap<Compilation.Node, String>();
            GraphInput graphInput = this.convert(compilation.getInput(), map);
            localScope = graphInput == GraphInput.DEFAULT || graphInput == GraphInput.NOTFILTER_OR_LOCAL;
        }
        catch (CompilationException compilationException) {
            // empty catch block
        }
        return localScope;
    }

    private GraphInput convert(Compilation.Node node, Map<Compilation.Node, String> map) {
        GraphInput graphInput = GraphInput.DEFAULT;
        String element = map.get(node);
        if (element == null) {
            if (node.getChildren().isEmpty()) {
                element = "output node";
            } else if (node.getParentCount() == 0) {
                element = "input node";
                graphInput = this.convert(node.getChildren(), map);
            } else {
                element = "action";
                Action action = node.getAction();
                if (action != null) {
                    graphInput = action instanceof AbstractFilter && ((AbstractFilter)action).useWholeGraphAsInput() ? GraphInput.GLOBAL : GraphInput.NOTFILTER_OR_LOCAL;
                }
            }
            map.put(node, element);
        }
        return graphInput;
    }

    private GraphInput convert(Collection<Compilation.Node> dependants, Map<Compilation.Node, String> map) {
        Compilation.Node node;
        GraphInput graphInput = GraphInput.DEFAULT;
        Iterator<Compilation.Node> iterator = dependants.iterator();
        while (iterator.hasNext() && (graphInput = this.convert(node = iterator.next(), map)) != GraphInput.GLOBAL && graphInput != GraphInput.NOTFILTER_OR_LOCAL) {
        }
        return graphInput;
    }

    private static class NoCache
    extends MachineInputProvider {
        private NoCache() {
        }

        @Override
        public MachineInput getInputDescriptor(MachineDescriptor machine) {
            return this.calculateConstraint(machine);
        }
    }

    private static class MachineInputTreeNode
    implements MachineInput {
        private LinkedList<MachineInputTreeNode> _children;
        private final MachineInput _input;
        private String[] _entityTypes;

        public MachineInputTreeNode(MachineInput input) {
            this._input = input;
        }

        public MachineInput getInput() {
            return this._input;
        }

        public void addChild(MachineInputTreeNode node) {
            if (this._children == null) {
                this._children = new LinkedList();
            }
            this._children.add(node);
        }

        public Collection<MachineInputTreeNode> getChildren() {
            if (this._children == null) {
                return Collections.emptySet();
            }
            return this._children;
        }

        @Override
        public boolean continueCheck() {
            return false;
        }

        @Override
        public boolean isSatisfiedByAny(AutomationContext ctx, Payload payload, InheritedTypesProvider typesProvider) {
            return this.isSatisfiedByAny(this, ctx, payload, typesProvider);
        }

        private boolean isSatisfiedByAny(MachineInputTreeNode node, AutomationContext ctx, Payload payload, InheritedTypesProvider typesProvider) {
            if (!node._input.isSatisfiedByAny(ctx, payload, typesProvider)) {
                return false;
            }
            if (!node.getChildren().isEmpty()) {
                boolean result = false;
                for (MachineInputTreeNode child : node.getChildren()) {
                    if (!this.isSatisfiedByAny(child, ctx, payload, typesProvider)) continue;
                    result = true;
                    break;
                }
                return result;
            }
            return true;
        }

        @Override
        public String[] getSupportedEntityTypes() {
            if (this._entityTypes == null) {
                HashSet<String> entities = new HashSet<String>();
                this.collectEntities(this, entities);
                this._entityTypes = entities.toArray(new String[entities.size()]);
                return entities.toArray(new String[entities.size()]);
            }
            return this._entityTypes;
        }

        private void collectEntities(MachineInputTreeNode node, Set<String> list) {
            boolean addChildren;
            String[] entities = node._input.getSupportedEntityTypes();
            if (entities == null) {
                addChildren = true;
            } else if (entities.length == 0) {
                addChildren = false;
            } else {
                list.addAll(Arrays.asList(entities));
                addChildren = false;
            }
            if (addChildren) {
                for (MachineInputTreeNode child : node.getChildren()) {
                    this.collectEntities(child, list);
                }
            }
        }
    }

    private static enum GraphInput {
        DEFAULT,
        GLOBAL,
        NOTFILTER_OR_LOCAL;

    }
}

