/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.view.MachineNodeAction;
import java.io.IOException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public final class CloneMachineAction
extends MachineNodeAction {
    public CloneMachineAction() {
        super("CTL_CloneMachineAction");
    }

    protected void performAction(Node[] nodes) {
        MachineDescriptor machine = this.getMachine(nodes);
        if (machine != null) {
            try {
                String name = this.getUniqueName(machine.getName());
                String displayName = machine.getDisplayName().replaceFirst("(\\s\\(Copy\\))?$", " (Copy)");
                String description = machine.getDescription();
                MachineDescriptor newMachine = new MachineDescriptor(name, displayName, description);
                newMachine.setAuthor(machine.getAuthor());
                newMachine.setEnabled(machine.isEnabled());
                newMachine.setMimeType(machine.getMimeType());
                newMachine.setReadOnly(false);
                Object data = machine.getData();
                if (data instanceof String) {
                    String dataStr = (String)data;
                    data = dataStr.replaceFirst("(?i)machine\\s*\\(([^\\)\"]*\"[^\"]*\"[^\\)\"]*)*\\)", this.createHeader(newMachine));
                }
                newMachine.setData(data);
                MachineRepository.getDefault().add(newMachine);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    protected String iconResource() {
        return "com/paterva/maltego/automation/resources/Clone.png";
    }

    private String getUniqueName(String name) throws IOException {
        String newName;
        MachineRepository repo = MachineRepository.getDefault();
        int index = 1;
        do {
            newName = name + index;
            ++index;
        } while (repo.exists(newName));
        return newName;
    }

    private String createHeader(MachineDescriptor machine) {
        StringBuilder sb = new StringBuilder("machine(\"");
        sb.append(machine.getName());
        sb.append("\",\n    displayName:\"");
        sb.append(machine.getDisplayName());
        sb.append("\",\n    author:\"");
        sb.append(machine.getAuthor());
        sb.append("\",\n    description:\"");
        sb.append(machine.getDescription());
        sb.append("\")");
        return sb.toString();
    }
}

