/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.impl;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.StringUtilities;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class FileSystemMachineRepository
extends MachineRepository {
    private static final String MALTEGO_FOLDER = "Maltego";
    private static final String EXTENSION = "machine";
    private String _machinesFolder;
    private Map<MachineDescriptor, FileObject> _map;
    private FileObject _configRoot;

    public FileSystemMachineRepository() {
        this(FileUtil.getConfigRoot());
    }

    public FileSystemMachineRepository(FileObject configRoot) {
        this("Machines", configRoot);
    }

    public FileSystemMachineRepository(String folder) {
        this(folder, FileUtil.getConfigRoot());
    }

    public FileSystemMachineRepository(String folder, FileObject configRoot) {
        this._machinesFolder = folder;
        this._configRoot = configRoot;
    }

    @Override
    public synchronized Collection<? extends MachineDescriptor> getAll() throws IOException {
        return this.map().keySet();
    }

    private FileObject getOrCreateMachinesFolder() throws IOException {
        return FileUtilities.getOrCreate((FileObject)this.getOrCreateMaltegoFolder(), (String)this._machinesFolder);
    }

    private FileObject getOrCreateMaltegoFolder() throws IOException {
        return FileUtilities.getOrCreate((FileObject)this._configRoot, (String)MALTEGO_FOLDER);
    }

    private FileObject getMachinesFolder() {
        FileObject maltegoFolder = this._configRoot.getFileObject(MALTEGO_FOLDER);
        if (maltegoFolder != null) {
            return maltegoFolder.getFileObject(this._machinesFolder);
        }
        return null;
    }

    private Map<MachineDescriptor, FileObject> map() throws IOException {
        if (this._map == null) {
            this._map = this.load();
        }
        return this._map;
    }

    private Map<MachineDescriptor, FileObject> load() throws IOException {
        HashMap<MachineDescriptor, FileObject> map = new HashMap<MachineDescriptor, FileObject>();
        FileObject folder = this.getMachinesFolder();
        if (folder != null) {
            Enumeration fileEnum = folder.getData(false);
            while (fileEnum.hasMoreElements()) {
                FileObject file = (FileObject)fileEnum.nextElement();
                if (!EXTENSION.equals(file.getExt())) continue;
                MachineDescriptor info = this.load(file);
                map.put(info, file);
            }
        }
        return map;
    }

    protected MachineDescriptor load(FileObject file) throws IOException {
        String displayName = FileSystemMachineRepository.unescapeXml((String)file.getAttribute("displayName"));
        String description = FileSystemMachineRepository.unescapeXml((String)file.getAttribute("description"));
        MachineDescriptor descriptor = new MachineDescriptor(file.getName(), displayName, description);
        descriptor.setEnabled(this.getAttribute(file, "enabled", true));
        descriptor.setAuthor(FileSystemMachineRepository.unescapeXml((String)file.getAttribute("author")));
        descriptor.setData(this.readText(file));
        descriptor.setMimeType("text/plain");
        descriptor.setReadOnly(this.getAttribute(file, "readonly", false));
        descriptor.setFavorite(this.getAttribute(file, "favorite", false));
        String hubItems = this.getAttribute(file, "hubItems", null);
        if (StringUtilities.isNullOrEmpty((String)hubItems)) {
            descriptor.setHubItems(Collections.emptySet());
        } else {
            descriptor.setHubItems(new LinkedHashSet<String>(Arrays.asList(hubItems.split(";"))));
        }
        return descriptor;
    }

    private void save(FileObject file, MachineDescriptor machine) throws IOException {
        block26: {
            try (BufferedOutputStream out = new BufferedOutputStream(file.getOutputStream());){
                file.setAttribute("enabled", (Object)machine.isEnabled());
                IOUtils.write((String)((String)machine.getData()), (OutputStream)out, (String)"UTF-8");
                file.setAttribute("displayName", (Object)FileSystemMachineRepository.escapeXml(machine.getDisplayName()));
                file.setAttribute("description", (Object)FileSystemMachineRepository.escapeXml(machine.getDescription()));
                file.setAttribute("author", (Object)FileSystemMachineRepository.escapeXml(machine.getAuthor()));
                file.setAttribute("readonly", (Object)machine.isReadOnly());
                file.setAttribute("favorite", (Object)machine.isFavorite());
                file.setAttribute("hubItems", (Object)machine.getHubItems().stream().map(Object::toString).collect(Collectors.joining(";")));
                String name = machine.getName();
                if (this.hasIllegalCharacters(name)) {
                    throw new IOException(name + " contains illegal characters.");
                }
                if (file.getName().equals(name)) break block26;
                try (FileLock lock = file.lock();){
                    if (lock != null) {
                        file.rename(lock, name, EXTENSION);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readText(FileObject file) throws IOException {
        try (InputStream is = null;){
            is = file.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
            String string = writer.toString();
            return string;
        }
    }

    private String getAttribute(FileObject file, String name, String defaultValue) {
        String s = (String)file.getAttribute(name);
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    private boolean getAttribute(FileObject file, String name, boolean defaultValue) {
        Boolean b = (Boolean)file.getAttribute(name);
        if (b == null) {
            return defaultValue;
        }
        return b;
    }

    @Override
    public synchronized void add(MachineDescriptor descriptor) throws IOException {
        FileObject folder = this.getOrCreateMachinesFolder();
        String name = descriptor.getName();
        if (this.hasIllegalCharacters(name)) {
            throw new IOException(name + " contains illegal characters.");
        }
        FileObject file = folder.createData(String.format("%s.%s", name, EXTENSION));
        this.save(file, descriptor);
        this.map().put(descriptor, file);
        this.fireItemAdded(descriptor);
    }

    @Override
    public synchronized void update(MachineDescriptor descriptor) throws IOException {
        FileObject file = this.map().get(descriptor);
        if (file == null) {
            throw new IOException(String.format("Descriptor '%s' not in cache.", descriptor.getName()));
        }
        this.save(file, descriptor);
        this.fireItemChanged(descriptor);
    }

    public static String escapeXml(String text) {
        return StringUtilities.lang3EscapeHtml4ToLang2EscapeHtml((String)StringEscapeUtils.escapeXml11((String)text));
    }

    public static String unescapeXml(String text) {
        return StringEscapeUtils.unescapeXml((String)text);
    }

    private static String replaceIllegalChars(String filename) {
        return filename.replaceAll("[^A-Za-z0-9._ ]", "_");
    }

    @Override
    public synchronized void remove(MachineDescriptor descriptor) throws IOException {
        FileObject file = this.map().get(descriptor);
        if (file != null) {
            file.delete();
            this.map().remove(descriptor);
            this.fireItemRemoved(descriptor);
        }
    }

    @Override
    public MachineDescriptor get(String id) throws IOException {
        for (MachineDescriptor desc : this.map().keySet()) {
            if (!desc.getName().equals(id)) continue;
            return desc;
        }
        return null;
    }

    private boolean hasIllegalCharacters(String name) {
        return name.matches(".*[^A-Za-z0-9._ -].*");
    }
}

