/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.view2d.EntityLabelMax;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import yguard.A.A.E;
import yguard.A.A.Y;
import yguard.A.J.BA;
import yguard.A.J.SA;

public class EntityLabelOptions {
    public static boolean isEnabled(EntityLabelMax option) {
        Boolean enabled = option.isEnabled();
        if (enabled == null) {
            enabled = EntityLabelOptions.getPrefs().getBoolean(option.getEnabledPreferenceName(), true);
            option.setEnabled(enabled);
        }
        return enabled;
    }

    public static void setEnabled(EntityLabelMax option, boolean enabled) {
        Boolean oldEnabled = option.isEnabled();
        if (oldEnabled == null || oldEnabled != enabled) {
            option.setEnabled(enabled);
            EntityLabelOptions.getPrefs().putBoolean(option.getEnabledPreferenceName(), enabled);
            EntityLabelOptions.updateLabels();
        }
    }

    public static int getMaxLength(EntityLabelMax option) {
        Integer max = option.getMax();
        if (max == null) {
            max = EntityLabelOptions.getPrefs().getInt(option.getMaxPreferenceName(), option.getDefaultMax());
            option.setMax(max);
        }
        return max;
    }

    public static void setMaxLength(EntityLabelMax option, int max) {
        Integer oldMax = option.getMax();
        if (oldMax == null || oldMax != max) {
            option.setMax(max);
            EntityLabelOptions.getPrefs().putInt(option.getMaxPreferenceName(), max);
            EntityLabelOptions.updateLabels();
        }
    }

    private static Preferences getPrefs() {
        return NbPreferences.forModule(EntityLabelOptions.class);
    }

    private static void updateLabels() {
        for (TopComponent tc : GraphEditorRegistry.getDefault().getOpen()) {
            GraphView graphView = (GraphView)tc.getLookup().lookup(GraphView.class);
            SA viewGraph = graphView.getViewGraph();
            E nc = viewGraph.\u00a4();
            while (nc.ok()) {
                LightweightEntityRealizer ler;
                Y node = nc.B();
                BA realizer = viewGraph.f(node);
                if (realizer instanceof LightweightEntityRealizer && (ler = (LightweightEntityRealizer)realizer).isInflated() && ler.labelCount() > 0) {
                    ler.updateLabels();
                }
                nc.next();
            }
        }
    }
}

