/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphLink;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.imgfactory.parts.LinkImageFactory;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.nodes.BulkQueryLinkCache;
import com.paterva.maltego.ui.graph.nodes.LinkNodeToLinkSpecConverter;
import com.paterva.maltego.ui.graph.nodes.LinkNodeToMaltegoLinkConverter;
import com.paterva.maltego.ui.graph.nodes.LinkProperties;
import com.paterva.maltego.ui.graph.nodes.NodeConverterKey;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Image;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class LinkNode
extends AbstractNode {
    private final BulkQueryLinkCache _linkCache;
    private GraphID _graphID;
    private LinkID _linkID;

    public LinkNode(GraphID graphID, LinkID linkID, BulkQueryLinkCache linkCache) {
        this(graphID, linkID, linkCache, new InstanceContent());
    }

    public LinkNode(GraphID graphID, LinkID linkID, BulkQueryLinkCache linkCache, InstanceContent content) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this._linkCache = linkCache;
        try {
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            if (view.getModelViewMappings().isOnlyViewLink(linkID)) {
                throw new IllegalArgumentException("NetBeans nodes may only be created for model links");
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        content.add((Object)graphID);
        content.add((Object)linkID);
        content.add(new NodeConverterKey<LinkNode>(this), (InstanceContent.Convertor)LinkNodeToMaltegoLinkConverter.instance());
        content.add(new NodeConverterKey<LinkNode>(this), (InstanceContent.Convertor)LinkNodeToLinkSpecConverter.instance());
        this._graphID = graphID;
        this._linkID = linkID;
        content.add((Object)new GraphLink(this._graphID, this._linkID));
    }

    public GraphID getGraphID() {
        return this._graphID;
    }

    public LinkID getLinkID() {
        return this._linkID;
    }

    public Image getIcon(int type) {
        return LinkImageFactory.getImage((MaltegoLinkSpec)this.getLinkSpec(), (int)this.getSize(type));
    }

    private int getSize(int type) {
        if (type == 1 || type == 3) {
            return 16;
        }
        return 32;
    }

    public String getDisplayName() {
        MaltegoLink link = this.getLink();
        if (link == null) {
            return "<removed>";
        }
        String displayName = InheritanceHelper.getDisplayString((SpecRegistry)LinkRegistry.getDefault(), (TypedPropertyBag)link);
        if (StringUtilities.isNullOrEmpty((String)displayName)) {
            displayName = "maltego.link.transform-link".equals(this.getLinkSpec().getTypeName()) ? "transform" : "link";
        }
        return displayName;
    }

    public MaltegoLink getLink() {
        return this._linkCache.getLink(this._linkID);
    }

    public MaltegoLinkSpec getLinkSpec() {
        MaltegoLink link = this.getLink();
        if (link != null) {
            LinkRegistry registry = LinkRegistry.forGraphID((GraphID)this._graphID);
            return (MaltegoLinkSpec)registry.get(link.getTypeName());
        }
        return null;
    }

    protected Sheet createSheet() {
        MaltegoLink link = this.getLink();
        if (link != null) {
            MaltegoLinkSpec spec = this.getLinkSpec();
            return LinkProperties.createSheet(this._graphID, (Node)this, link, spec);
        }
        return new Sheet();
    }
}

