/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.edit;

import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ui.image.ImageStripModel;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;

public class SummaryImageStripModel
implements ImageStripModel {
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private List<Attachment> _atts;
    private int _selected = -1;
    private ImageCallback _callback;
    private boolean _cached = false;

    public void setAttachments(List<Attachment> atts) {
        this._atts = atts;
        this._callback = __ -> this._changeSupport.firePropertyChange("imagesChanged", null, null);
        this._changeSupport.firePropertyChange("imagesChanged", null, null);
    }

    public void setSelected(Attachment att) {
        this._selected = att != null ? this._atts.indexOf(att) : -1;
        this._changeSupport.firePropertyChange("selectedChanged", null, null);
    }

    public int getImageCount() {
        if (this._atts != null) {
            return this._atts.size();
        }
        return 0;
    }

    public int getWidth(int index) {
        if (this._cached) {
            Attachment att = this._atts.get(index);
            Image image = ImageFactory.getDefault().getImage((Object)att, this._callback);
            if (image != null) {
                return image.getWidth(null);
            }
        }
        return 100;
    }

    public int getHeight(int index) {
        if (this._cached) {
            Attachment att = this._atts.get(index);
            Image image = ImageFactory.getDefault().getImage((Object)att, this._callback);
            if (image != null) {
                return image.getHeight(null);
            }
        }
        return 100;
    }

    public Object getImage(int index) {
        this._cached = true;
        return this._atts.get(index);
    }

    public boolean isHighlight(int index) {
        return this._selected == index;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }
}

