/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.HighlightStyle;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.editing.propertygrid.PropertyDescriptorProperty;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public class DisplayDescriptorProperty
extends PropertyDescriptorProperty {
    private PropertyEditor _propertyEditor;

    public DisplayDescriptorProperty(DisplayDescriptor descriptor, DataSource data) {
        super((PropertyDescriptor)descriptor, data);
    }

    public DisplayDescriptor getDisplayDescriptor() {
        return (DisplayDescriptor)this.getPropertyDescriptor();
    }

    @Override
    public String getHtmlDisplayName() {
        String colorPrefix = "";
        String colorSuffix = "";
        if (this.getDisplayDescriptor().getHighlight() == HighlightStyle.High) {
            colorPrefix = "<b>";
            colorSuffix = "</b>";
        } else if (this.getDisplayDescriptor().getHighlight() == HighlightStyle.Medium) {
            colorPrefix = "<em>";
            colorSuffix = "</em>";
        }
        return colorPrefix + super.getHtmlDisplayName() + colorSuffix;
    }

    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this._propertyEditor = propertyEditor;
    }

    public PropertyEditor getPropertyEditor() {
        if (this._propertyEditor == null) {
            return super.getPropertyEditor();
        }
        return this._propertyEditor;
    }

    public boolean isDefaultValue() {
        try {
            return this.isSame(this.getDisplayDescriptor().getDefaultValue(), this.getValue());
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return true;
        }
    }

    @Override
    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        Object o = super.getValue();
        if (o == null) {
            o = this.getDisplayDescriptor().getDefaultValue();
        }
        this.updateDisplay(o);
        return o;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(this.getDisplayDescriptor().getDefaultValue());
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isPreferred() {
        return super.isPreferred();
    }

    private boolean isSame(Object o1, Object o2) {
        return Objects.equals(o1, o2);
    }
}

