/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form.adapters;

import com.paterva.maltego.typing.editing.form.adapters.AbstractControlAdapter;
import com.paterva.maltego.util.FastURL;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class FastUrlTextBoxAdapter
extends AbstractControlAdapter<JTextField, FastURL> {
    FastUrlTextBoxAdapter() {
    }

    @Override
    public JTextField create() {
        JTextField field = this.createTextComponent();
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FastUrlTextBoxAdapter.this.fireEditingFinished(e);
            }
        });
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FastUrlTextBoxAdapter.this.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FastUrlTextBoxAdapter.this.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FastUrlTextBoxAdapter.this.fireChange();
            }
        });
        return field;
    }

    protected JTextField createTextComponent() {
        return new JTextField(25);
    }

    @Override
    public void setValue(Component component, Object value) {
        if (value == null || value instanceof FastURL) {
            super.setValue(component, value);
        } else {
            super.setValue(component, new FastURL(value.toString()));
        }
    }

    @Override
    protected void set(JTextField component, FastURL value) {
        if (value == null) {
            component.setText("");
        } else {
            component.setText(value.toString());
        }
    }

    @Override
    protected FastURL get(JTextField component) {
        String s = component.getText().trim();
        if (s.isEmpty()) {
            return null;
        }
        FastURL url = new FastURL(s);
        return url;
    }

    @Override
    protected boolean empty(JTextField component) {
        return "".equals(component.getText());
    }
}

