/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table;

import com.paterva.maltego.graph.table.TableIO;
import com.paterva.maltego.graph.table.TableIODecorator;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;

public class TableIOProgress
extends TableIODecorator {
    private ProgressHandle progressHandle;

    public TableIOProgress(TableIO table, ProgressHandle progressHandle) {
        super(table);
        this.progressHandle = progressHandle;
    }

    @Override
    public void addRow(List<String> row) {
        super.addRow(row);
        this.progressHandle.setDisplayName("Added Table Row #" + this.getRowCount());
    }

    @Override
    public Iterator<List<String>> rowIterator() {
        return new ProgressIterator(super.rowIterator());
    }

    class ProgressIterator
    implements Iterator<List<String>> {
        private int counter;
        private Iterator<List<String>> decorated;

        public ProgressIterator(Iterator<List<String>> iterator) {
            this.decorated = iterator;
            this.counter = 0;
        }

        @Override
        public boolean hasNext() {
            return this.decorated.hasNext();
        }

        @Override
        public List<String> next() {
            ++this.counter;
            TableIOProgress.this.progressHandle.setDisplayName("Read Table Row#" + this.counter + " of " + TableIOProgress.this.getRowCount());
            return this.decorated.next();
        }
    }
}

