/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws.registry;

import com.paterva.maltego.pws.api.PublicWebService;
import com.paterva.maltego.pws.api.PublicWebServices;
import com.paterva.maltego.pws.oauth.OAuthWebService;
import com.paterva.maltego.pws.serialization.OAuthAccount;
import com.paterva.maltego.pws.serialization.OAuthAccountSerializer;
import com.paterva.maltego.pws.serialization.OAuthServiceSerializer;
import com.paterva.maltego.util.FileUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class TypedServicesRegistry
extends PublicWebServices {
    private static final Logger LOG = Logger.getLogger(TypedServicesRegistry.class.getName());
    private static final String FOLDER = "Maltego/Services/";
    private static final String SERVICE_EXT = "service";
    private static final String ACCOUNT_EXT = "account";
    private Map<String, Map<String, PublicWebService>> _services;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport((Object)this);
    private final AccountListener _accountListener = new AccountListener();
    private final FileObject _configRoot;

    public TypedServicesRegistry() {
        this(FileUtil.getConfigRoot());
    }

    public TypedServicesRegistry(FileObject configRoot) {
        this._configRoot = configRoot;
    }

    public synchronized Map<String, Map<String, PublicWebService>> getServices() {
        if (this._services == null) {
            try {
                this._services = this.load();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this._services = new HashMap<String, Map<String, PublicWebService>>();
                try {
                    this.save();
                }
                catch (IOException ex1) {
                    Exceptions.printStackTrace((Throwable)ex1);
                }
            }
        }
        return this._services;
    }

    public Set<String> getServiceTypes() {
        return new HashSet<String>(this.getServices().keySet());
    }

    public Set<PublicWebService> getAll() {
        HashSet<PublicWebService> services = new HashSet<PublicWebService>();
        for (Map.Entry<String, Map<String, PublicWebService>> entry : this.getServices().entrySet()) {
            Map<String, PublicWebService> servicesMap = entry.getValue();
            if (servicesMap == null) continue;
            services.addAll(servicesMap.values());
        }
        return services;
    }

    public Set<String> getNames() {
        HashSet<String> names = new HashSet<String>();
        for (Map.Entry<String, Map<String, PublicWebService>> entry : this.getServices().entrySet()) {
            Map<String, PublicWebService> servicesMap = entry.getValue();
            if (servicesMap == null) continue;
            names.addAll(servicesMap.keySet());
        }
        return names;
    }

    public Set<PublicWebService> getAll(String type) {
        Map<String, PublicWebService> services = this.getServices().get(type);
        return services == null ? null : new HashSet<PublicWebService>(services.values());
    }

    public Set<String> getNames(String type) {
        Map<String, PublicWebService> services = this.getServices().get(type);
        return services == null ? null : new HashSet<String>(services.keySet());
    }

    public PublicWebService get(String name) {
        Map.Entry<String, Map<String, PublicWebService>> entry;
        Map<String, PublicWebService> servicesMap;
        PublicWebService service = null;
        Iterator<Map.Entry<String, Map<String, PublicWebService>>> iterator = this.getServices().entrySet().iterator();
        while (iterator.hasNext() && ((servicesMap = (entry = iterator.next()).getValue()) == null || (service = servicesMap.get(name)) == null)) {
        }
        return service;
    }

    public boolean replace(String type, String name, PublicWebService service) throws IOException {
        boolean mustAdd = true;
        PublicWebService serviceOld = this.get(name);
        if (serviceOld != null) {
            if (serviceOld.isCopyOf(service)) {
                mustAdd = false;
            } else {
                this.remove(name);
            }
        }
        if (mustAdd) {
            this.add(type, name, service);
        }
        return mustAdd;
    }

    public void add(String type, String name, PublicWebService service) throws IOException {
        LOG.log(Level.FINE, "Adding service: {0} {1} {2}", new Object[]{name, type, service});
        if (this.get(name) != null) {
            throw new IllegalStateException("Service " + name + " already exists");
        }
        Map<String, Map<String, PublicWebService>> services = this.getServices();
        Map<String, PublicWebService> servicesMap = services.get(type);
        if (servicesMap == null) {
            servicesMap = new HashMap<String, PublicWebService>();
            services.put(type, servicesMap);
        }
        servicesMap.put(name, service);
        this.save();
        this.addServiceListener(service);
        this.firePropertyChange("serviceAdded", null, name);
    }

    public void remove(String name) throws IOException {
        Map.Entry<String, Map<String, PublicWebService>> entry;
        Map<String, PublicWebService> servicesMap;
        LOG.log(Level.FINE, "Removing service: {0}", name);
        PublicWebService service = null;
        Iterator<Map.Entry<String, Map<String, PublicWebService>>> iterator = this.getServices().entrySet().iterator();
        while (iterator.hasNext() && (service = (servicesMap = (entry = iterator.next()).getValue()).remove(name)) == null) {
        }
        if (service != null) {
            this.removeServiceListener(service);
            this.save();
            this.firePropertyChange("serviceRemoved", name, null);
        }
    }

    public int size() {
        return this.getAll().size();
    }

    private Map<String, Map<String, PublicWebService>> load() throws IOException {
        HashMap<String, Map<String, PublicWebService>> services = new HashMap<String, Map<String, PublicWebService>>();
        FileObject folder = this.getFolder();
        if (folder != null) {
            for (FileObject folderObject : folder.getChildren()) {
                Map<String, PublicWebService> servicesMap;
                if (!folderObject.isFolder() || (servicesMap = this.load(folderObject)) == null) continue;
                services.put(folderObject.getName(), servicesMap);
            }
        }
        return services;
    }

    private Map<String, PublicWebService> load(FileObject folderObject) throws IOException {
        HashMap<String, PublicWebService> services = new HashMap<String, PublicWebService>();
        ArrayList accounts = new ArrayList();
        for (FileObject fileObject : folderObject.getChildren()) {
            if (fileObject.isFolder()) continue;
            if (SERVICE_EXT.equals(fileObject.getExt())) {
                this.loadService(fileObject).ifPresent(pws -> {
                    PublicWebService cfr_ignored_0 = services.put(pws.getName(), (PublicWebService)pws);
                });
                continue;
            }
            if (!ACCOUNT_EXT.equals(fileObject.getExt())) continue;
            this.loadAccount(fileObject).ifPresent(acc -> accounts.add(acc));
        }
        for (OAuthAccount oAuthAccount : accounts) {
            PublicWebService service = (PublicWebService)services.get(oAuthAccount.getServiceName());
            if (!(service instanceof OAuthWebService)) continue;
            OAuthWebService oauthService = (OAuthWebService)service;
            oauthService.addAccount(oAuthAccount.getAccessToken(), oAuthAccount.getAccessTokenExpiredAtTime(), oAuthAccount.getRefreshToken());
        }
        for (Map.Entry entry : services.entrySet()) {
            OAuthWebService service = (OAuthWebService)((Object)entry.getValue());
            this.addServiceListener(service);
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<OAuthWebService> loadService(FileObject fileObject) throws IOException {
        OAuthWebService service = null;
        try (InputStream inputStream = null;){
            inputStream = fileObject.getInputStream();
            OAuthServiceSerializer serializer = new OAuthServiceSerializer();
            service = serializer.read(inputStream);
            LOG.log(Level.FINE, "Service loaded: {0}", (Object)service);
        }
        return Optional.ofNullable(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<OAuthAccount> loadAccount(FileObject fileObject) throws IOException {
        OAuthAccount account = null;
        try (InputStream inputStream = null;){
            inputStream = fileObject.getInputStream();
            OAuthAccountSerializer serializer = new OAuthAccountSerializer();
            account = serializer.read(inputStream);
            LOG.log(Level.FINE, "Account loaded: {0}", account);
        }
        return Optional.ofNullable(account);
    }

    protected void save() throws IOException {
        this.clearCache();
        for (Map.Entry<String, Map<String, PublicWebService>> entry : this.getServices().entrySet()) {
            String type = entry.getKey();
            Map<String, PublicWebService> servicesMap = entry.getValue();
            if (servicesMap == null) continue;
            for (Map.Entry<String, PublicWebService> mapEntry : servicesMap.entrySet()) {
                OAuthWebService service = (OAuthWebService)mapEntry.getValue();
                this.saveService(type, service);
                for (OAuthAccount account : service.getAccounts()) {
                    this.saveAccount(type, account);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveService(String type, OAuthWebService service) throws IOException {
        FileObject folder = this.getFolder(type);
        String name = service.getName();
        FileObject file = FileUtilities.createUniqueFile((FileObject)folder, (String)FileUtilities.replaceIllegalChars((String)name), (String)SERVICE_EXT);
        try (OutputStream outputStream = null;){
            LOG.log(Level.FINE, "Saving service: {0}", (Object)service);
            outputStream = new BufferedOutputStream(file.getOutputStream());
            OAuthServiceSerializer serializer = new OAuthServiceSerializer();
            serializer.write(service, outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAccount(String type, OAuthAccount account) throws IOException {
        FileObject folder = this.getFolder(type);
        String name = account.getServiceName();
        FileObject file = FileUtilities.createUniqueFile((FileObject)folder, (String)FileUtilities.replaceIllegalChars((String)name), (String)ACCOUNT_EXT);
        try (OutputStream outputStream = null;){
            LOG.log(Level.FINE, "Saving account: {0}", account);
            outputStream = new BufferedOutputStream(file.getOutputStream());
            OAuthAccountSerializer serializer = new OAuthAccountSerializer();
            serializer.write(account, outputStream);
        }
    }

    private FileObject getFolder() throws IOException {
        return FileUtilities.getOrCreate((FileObject)this._configRoot, (String)FOLDER);
    }

    private FileObject getFolder(String serviceType) throws IOException {
        return FileUtilities.getOrCreate((FileObject)this._configRoot, (String)(FOLDER + serviceType));
    }

    private void clearCache() {
        try {
            this.getFolder().delete();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected void addServiceListener(PublicWebService service) {
        service.addPropertyChangeListener((PropertyChangeListener)this._accountListener);
    }

    protected void removeServiceListener(PublicWebService service) {
        service.removePropertyChangeListener((PropertyChangeListener)this._accountListener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this._changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    public static class ReadOnly
    extends TypedServicesRegistry {
        public ReadOnly(FileObject configRoot) {
            super(configRoot);
        }

        @Override
        protected void save() throws IOException {
        }

        @Override
        protected void addServiceListener(PublicWebService service) {
        }

        @Override
        protected void removeServiceListener(PublicWebService service) {
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }

    private class AccountListener
    implements PropertyChangeListener {
        private AccountListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                TypedServicesRegistry.this.save();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

