/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon;

import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.internal.ui.ribbon.CommandButtonLayoutManagerBigFixed;
import org.pushingpixels.flamingo.internal.ui.ribbon.CommandButtonLayoutManagerBigFixedLandscape;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonGallery;

public class JRibbonBand
extends AbstractRibbonBand<JBandControlPanel> {
    public static final CommandButtonDisplayState BIG_FIXED_LANDSCAPE = new CommandButtonDisplayState("Big Fixed Landscape", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton button) {
            return new CommandButtonLayoutManagerBigFixedLandscape();
        }
    };
    public static final CommandButtonDisplayState BIG_FIXED = new CommandButtonDisplayState("Big Fixed", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton button) {
            return new CommandButtonLayoutManagerBigFixed();
        }
    };

    public JRibbonBand(String title, ResizableIcon icon) {
        this(title, icon, null);
    }

    public JRibbonBand(String title, ResizableIcon icon, ActionListener expandActionListener) {
        super(title, icon, expandActionListener, new JBandControlPanel());
        this.resizePolicies = Collections.unmodifiableList(CoreRibbonResizePolicies.getCorePoliciesPermissive(this));
        this.updateUI();
    }

    public void addCommandButton(AbstractCommandButton commandButton, RibbonElementPriority priority) {
        commandButton.setHorizontalAlignment(2);
        ((JBandControlPanel)this.controlPanel).addCommandButton(commandButton, priority);
    }

    public void addRibbonGallery(String galleryName, List<StringValuePair<List<JCommandToggleButton>>> buttons, Map<RibbonElementPriority, Integer> preferredVisibleButtonCounts, int preferredPopupMaxButtonColumns, int preferredPopupMaxVisibleButtonRows, RibbonElementPriority priority) {
        this.addRibbonGallery(galleryName, buttons, preferredVisibleButtonCounts, preferredPopupMaxButtonColumns, preferredPopupMaxVisibleButtonRows, BIG_FIXED_LANDSCAPE, priority);
    }

    public void addRibbonGallery(String galleryName, List<StringValuePair<List<JCommandToggleButton>>> buttons, Map<RibbonElementPriority, Integer> preferredVisibleButtonCounts, int preferredPopupMaxButtonColumns, int preferredPopupMaxVisibleButtonRows, CommandButtonDisplayState ribbonButtonDisplayState, RibbonElementPriority priority) {
        JRibbonGallery gallery = new JRibbonGallery();
        gallery.setButtonDisplayState(ribbonButtonDisplayState);
        gallery.setName(galleryName);
        for (Map.Entry<RibbonElementPriority, Integer> prefCountEntry : preferredVisibleButtonCounts.entrySet()) {
            gallery.setPreferredVisibleButtonCount(prefCountEntry.getKey(), prefCountEntry.getValue());
        }
        gallery.setGroupMapping(buttons);
        gallery.setPreferredPopupPanelDimension(preferredPopupMaxButtonColumns, preferredPopupMaxVisibleButtonRows);
        ((JBandControlPanel)this.controlPanel).addRibbonGallery(gallery, priority);
    }

    public void addRibbonGalleryButtons(String galleryName, String buttonGroupName, JCommandToggleButton ... buttons) {
        JRibbonGallery gallery = ((JBandControlPanel)this.controlPanel).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.addRibbonGalleryButtons(buttonGroupName, buttons);
    }

    public void removeRibbonGalleryButtons(String galleryName, JCommandToggleButton ... buttons) {
        JRibbonGallery gallery = ((JBandControlPanel)this.controlPanel).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.removeRibbonGalleryButtons(buttons);
    }

    public void setSelectedRibbonGalleryButton(String galleryName, JCommandToggleButton buttonToSelect) {
        JRibbonGallery gallery = ((JBandControlPanel)this.controlPanel).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.setSelectedButton(buttonToSelect);
    }

    public void setRibbonGalleryButtonDisplayState(String galleryName, CommandButtonDisplayState displayState) {
        JRibbonGallery gallery = ((JBandControlPanel)this.controlPanel).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.setButtonDisplayState(displayState);
    }

    public void setRibbonGalleryPopupCallback(String galleryName, RibbonGalleryPopupCallback popupCallback) {
        JRibbonGallery gallery = ((JBandControlPanel)this.controlPanel).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.setPopupCallback(popupCallback);
    }

    public void setRibbonGalleryExpandKeyTip(String galleryName, String expandKeyTip) {
        JRibbonGallery gallery = ((JBandControlPanel)this.controlPanel).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.setExpandKeyTip(expandKeyTip);
    }

    public void addRibbonComponent(JRibbonComponent comp) {
        ((JBandControlPanel)this.controlPanel).addRibbonComponent(comp);
    }

    public void addRibbonComponent(JRibbonComponent comp, int rowSpan) {
        int availableRows;
        int groupCount = ((JBandControlPanel)this.controlPanel).getControlPanelGroupCount();
        String groupTitle = groupCount > 0 ? ((JBandControlPanel)this.controlPanel).getControlPanelGroupTitle(groupCount - 1) : null;
        int n = availableRows = groupTitle == null ? 3 : 2;
        if (rowSpan <= 0 || rowSpan > availableRows) {
            throw new IllegalArgumentException("Row span value not supported. Should be in 1.." + availableRows + " range");
        }
        ((JBandControlPanel)this.controlPanel).addRibbonComponent(comp, rowSpan);
    }

    public int startGroup() {
        return ((JBandControlPanel)this.controlPanel).startGroup();
    }

    public int startGroup(String groupTitle) {
        return ((JBandControlPanel)this.controlPanel).startGroup(groupTitle);
    }

    public void setGroupTitle(int groupIndex, String groupTitle) {
        ((JBandControlPanel)this.controlPanel).setGroupTitle(groupIndex, groupTitle);
    }

    public List<JRibbonComponent> getRibbonComponents(int groupIndex) {
        return ((JBandControlPanel)this.controlPanel).getRibbonComponents(groupIndex);
    }

    @Override
    public AbstractRibbonBand<JBandControlPanel> cloneBand() {
        JRibbonBand result = new JRibbonBand(this.getTitle(), this.getIcon(), this.getExpandActionListener());
        result.applyComponentOrientation(this.getComponentOrientation());
        return result;
    }

    public static interface RibbonGalleryPopupCallback {
        public void popupToBeShown(JCommandPopupMenu var1);
    }
}

