/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.treelist;

import com.paterva.maltego.util.ui.ctxmenu.ChildlessTreeListItem;
import com.paterva.maltego.util.ui.search.SearchRunItem;
import com.paterva.maltego.util.ui.treelist.AbstractTreeListItemPanel;
import com.paterva.maltego.util.ui.treelist.DefaultTreeListComponentFactory;
import com.paterva.maltego.util.ui.treelist.TreeListComponentFactory;
import com.paterva.maltego.util.ui.treelist.TreeListExpandAnimator;
import com.paterva.maltego.util.ui.treelist.TreeListInflateAnimator;
import com.paterva.maltego.util.ui.treelist.TreeListItem;
import com.paterva.maltego.util.ui.treelist.TreeListItemEvent;
import com.paterva.maltego.util.ui.treelist.TreeListItemListener;
import com.paterva.maltego.util.ui.treelist.TreeListItemPanel;
import com.paterva.maltego.util.ui.treelist.TreeListMenuFactory;
import com.paterva.maltego.util.ui.treelist.TreeListSlideAnimator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TreeListPanel
extends JPanel
implements Scrollable {
    private static final int SCROLL_UNIT = 16;
    private final TreeListItem _rootItem;
    private final TreeListComponentFactory _factory;
    private final DefaultListSelectionModel _selectionModel = new DefaultListSelectionModel();
    private TreeListListener _treeListListener;
    private InputListener _inputListener;
    private MouseListener _itemInputListener;
    private TreeItemSelectionListener _treeItemSelectionListener;
    private int _dragFirstIndex = -1;
    private int _dragLastIndex = -1;
    private boolean _syncingSelection = false;
    private TreeListItemListener _treeListItemListener;
    private boolean _stretchHeightToViewport = true;
    private boolean _scrollableTracksViewportHeight = false;
    private int _indentSize = 10;

    public TreeListPanel(TreeListItem rootItem) {
        this(rootItem, null);
    }

    public TreeListPanel(TreeListItem rootItem, TreeListItemListener itemListener) {
        this(rootItem, new DefaultTreeListComponentFactory(), itemListener);
    }

    public TreeListPanel(TreeListItem rootItem, TreeListComponentFactory factory, TreeListItemListener itemListener) {
        super(new GridBagLayout(), true);
        this._rootItem = rootItem;
        this._factory = factory;
        this._itemInputListener = new ItemInputListener();
        this._treeListItemListener = itemListener;
        this._selectionModel.setSelectionMode(2);
        InputMap im = this.getInputMap();
        im.put(KeyStroke.getKeyStroke(38, 0), "Arrow.up");
        im.put(KeyStroke.getKeyStroke(40, 0), "Arrow.down");
        im.put(KeyStroke.getKeyStroke(33, 0), "PageUp");
        im.put(KeyStroke.getKeyStroke(34, 0), "PageDown");
        AbstractAction doNothing = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        ActionMap am = this.getActionMap();
        am.put("Arrow.up", doNothing);
        am.put("Arrow.down", doNothing);
        am.put("PageUp", doNothing);
        am.put("PageDown", doNothing);
    }

    public void setStretchHeightToViewport(boolean stretch) {
        this._stretchHeightToViewport = stretch;
    }

    public void setItemIndentSize(int indentSize) {
        this._indentSize = indentSize;
    }

    @Override
    public Color getBackground() {
        return UIManager.getLookAndFeelDefaults().getColor("run-bg-color");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._inputListener = new InputListener();
        this.addMouseListener(this._inputListener);
        this.addKeyListener(this._inputListener);
        this.addFocusListener(this._inputListener);
        this.addAllItems();
        this._treeListListener = new TreeListListener();
        this._rootItem.addPropertyChangeListener(this._treeListListener);
        this._treeItemSelectionListener = new TreeItemSelectionListener();
        this._selectionModel.addListSelectionListener(this._treeItemSelectionListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAllItems();
        this.removeMouseListener(this._inputListener);
        this.removeKeyListener(this._inputListener);
        this.removeFocusListener(this._inputListener);
        this._inputListener = null;
        this._rootItem.removePropertyChangeListener(this._treeListListener);
        this._treeListListener = null;
        this._selectionModel.removeListSelectionListener(this._treeItemSelectionListener);
        this._treeItemSelectionListener = null;
    }

    void removeAllItems() {
        this.removeItemInputListeners();
        this.removeAll();
    }

    TreeListItem getRootItem() {
        return this._rootItem;
    }

    void addAllItems() {
        this.removeAllItems();
        this.addItems(this._rootItem.getAsList());
        this.addFiller();
    }

    void addItems(List<TreeListItem> items) {
        int y = 0;
        for (TreeListItem item : items) {
            if (item instanceof ChildlessTreeListItem && ((ChildlessTreeListItem)item).getDelegate() instanceof SearchRunItem) continue;
            GridBagConstraints constraints = this.createContraints(item);
            AbstractTreeListItemPanel itemPanel = this._factory.getComponent(item);
            this.addItemInputListeners(itemPanel);
            if (y == 0 || !item.isVisible()) {
                itemPanel.setVisible(false);
            }
            this.add((Component)itemPanel, constraints);
            ++y;
        }
    }

    void addFiller() {
        GridBagConstraints constraints = this.createDefaultConstraints();
        constraints.weighty = 1.0;
        JPanel placeholder = new JPanel();
        placeholder.setBackground(this.getBackground());
        placeholder.setPreferredSize(new Dimension(0, 0));
        this.add((Component)placeholder, constraints);
    }

    private GridBagConstraints createContraints(TreeListItem item) {
        GridBagConstraints constraints = this.createDefaultConstraints();
        constraints.insets.left = (item.getDepth() - 1) * this._indentSize;
        return constraints;
    }

    private GridBagConstraints createDefaultConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        return constraints;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this._stretchHeightToViewport) {
            int height = this.getParent().getHeight();
            size.height = Math.max(height, size.height);
        }
        return size;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 16;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (orientation == 1 ? visibleRect.height : visibleRect.width) - 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public void setScrollableTracksViewportHeight(boolean scrollableTracksViewportHeight) {
        this._scrollableTracksViewportHeight = scrollableTracksViewportHeight;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this._scrollableTracksViewportHeight;
    }

    private void addItemInputListeners(JPanel itemPanel) {
        itemPanel.addMouseListener(this._itemInputListener);
    }

    private void removeItemInputListeners() {
        for (Component component : this.getComponents()) {
            if (!(component instanceof TreeListItemPanel)) continue;
            this.removeItemInputListeners((TreeListItemPanel)component);
        }
    }

    private void removeItemInputListeners(TreeListItemPanel itemPanel) {
        itemPanel.removeMouseListener(this._itemInputListener);
    }

    public int getItemPanelIndex(TreeListItemPanel panel) {
        if (panel == null) {
            return -1;
        }
        int index = 0;
        for (Component c : this.getComponents()) {
            if (panel.equals(c)) break;
            ++index;
        }
        return index;
    }

    private int getIndex(Component component) {
        TreeListItemPanel treeListItemPanel = this.getTreeListItemPanel(component);
        return this.getItemPanelIndex(treeListItemPanel);
    }

    private TreeListItemPanel getTreeListItemPanel(Component component) {
        while (component != null && !(component instanceof TreeListItemPanel)) {
            component = component.getParent();
        }
        return (TreeListItemPanel)component;
    }

    private boolean isValidIndex(int index) {
        return index >= 0 && index < this.getComponentCount() - 1;
    }

    private boolean handle(MouseEvent e) {
        boolean handled = false;
        if (this._treeListItemListener != null) {
            TreeListItemPanel treeListItemPanel = this.getTreeListItemPanel((Component)e.getSource());
            TreeListItem item = treeListItemPanel != null ? treeListItemPanel.getTreeListItem() : null;
            handled = this._treeListItemListener.onClicked(item, e);
        }
        return handled;
    }

    protected void updateSelection(int index, InputEvent e) {
        DefaultListSelectionModel sm = this._selectionModel;
        if (index != -1) {
            sm.setValueIsAdjusting(true);
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    if (this._dragFirstIndex == -1) {
                        sm.addSelectionInterval(index, index);
                    } else if (this._dragLastIndex == -1) {
                        sm.addSelectionInterval(this._dragFirstIndex, index);
                    } else {
                        sm.removeSelectionInterval(this._dragFirstIndex, this._dragLastIndex);
                        sm.addSelectionInterval(this._dragFirstIndex, index);
                    }
                } else if (this._dragFirstIndex == -1) {
                    sm.addSelectionInterval(index, index);
                } else {
                    sm.setSelectionInterval(this._dragFirstIndex, index);
                }
                if (this._dragFirstIndex == -1) {
                    this._dragFirstIndex = index;
                    this._dragLastIndex = -1;
                } else {
                    this._dragLastIndex = index;
                }
            } else {
                if (e.isControlDown()) {
                    if (sm.isSelectedIndex(index)) {
                        sm.removeSelectionInterval(index, index);
                    } else {
                        sm.addSelectionInterval(index, index);
                    }
                } else {
                    sm.setSelectionInterval(index, index);
                }
                this._dragFirstIndex = index;
                this._dragLastIndex = -1;
            }
            sm.setValueIsAdjusting(false);
        } else {
            sm.clearSelection();
        }
    }

    private void syncSelection() {
        this._syncingSelection = true;
        this._selectionModel.setValueIsAdjusting(true);
        this._selectionModel.clearSelection();
        int componentNum = 0;
        for (Component component : this.getComponents()) {
            TreeListItemPanel itemPanel;
            if (component instanceof TreeListItemPanel && (itemPanel = (TreeListItemPanel)component).isSelected()) {
                this._selectionModel.addSelectionInterval(componentNum, componentNum);
            }
            ++componentNum;
        }
        this._selectionModel.setValueIsAdjusting(false);
        this._syncingSelection = false;
    }

    private class TreeItemSelectionListener
    implements ListSelectionListener {
        private TreeItemSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!TreeListPanel.this._syncingSelection && !e.getValueIsAdjusting()) {
                Component[] components = TreeListPanel.this.getComponents();
                int startIndex = 0;
                int endIndex = components.length;
                for (int i = startIndex; i < endIndex; ++i) {
                    boolean selected = TreeListPanel.this._selectionModel.isSelectedIndex(i);
                    if (!(components[i] instanceof TreeListItemPanel)) continue;
                    TreeListItemPanel c = (TreeListItemPanel)components[i];
                    c.getTreeListItem().setSelected(selected);
                }
                int leadIndex = TreeListPanel.this._selectionModel.getLeadSelectionIndex();
                try {
                    Component leadComponent = components[leadIndex];
                    TreeListPanel.this.scrollRectToVisible(leadComponent.getBounds());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    private class TreeListListener
    implements PropertyChangeListener {
        private final TreeListExpandAnimator _expandAnimator;
        private final TreeListInflateAnimator _inflateAnimator;
        private final TreeListSlideAnimator _slideAnimator;

        private TreeListListener() {
            this._expandAnimator = new TreeListExpandAnimator(TreeListPanel.this);
            this._inflateAnimator = new TreeListInflateAnimator(TreeListPanel.this);
            this._slideAnimator = new TreeListSlideAnimator(TreeListPanel.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new IllegalThreadStateException("Must be in EDT.");
            }
            TreeListItemEvent event = (TreeListItemEvent)evt.getNewValue();
            if ("expandedChanged".equals(evt.getPropertyName())) {
                this._inflateAnimator.completeAll();
                this._slideAnimator.complete();
                this._expandAnimator.start(event.getItem());
            } else if ("changed".equals(evt.getPropertyName())) {
                int listIndex = event.getListIndex();
                TreeListPanel.this.getComponents()[listIndex].repaint();
            } else if ("childAdded".equals(evt.getPropertyName())) {
                this._expandAnimator.stop();
                this._slideAnimator.complete();
                TreeListItem item = event.getItem();
                AbstractTreeListItemPanel component = TreeListPanel.this._factory.getComponent(item);
                int index = this.getInsertIndex(event.getListIndex());
                TreeListPanel.this.addItemInputListeners(component);
                component.setVisible(item.isVisible());
                TreeListPanel.this.add(component, TreeListPanel.this.createContraints(item), index);
                if (item.isVisible()) {
                    this._inflateAnimator.inflate(component);
                }
                TreeListPanel.this.syncSelection();
            } else if ("childRemoved".equals(evt.getPropertyName())) {
                this._expandAnimator.stop();
                this._slideAnimator.complete();
                TreeListItem item = event.getItem();
                int count = item.getAsList().size();
                int start = event.getListIndex();
                int end = start + count;
                ArrayList<TreeListItemPanel> components = new ArrayList<TreeListItemPanel>();
                int listNum = 0;
                for (Component component : TreeListPanel.this.getComponents()) {
                    if (!(component instanceof TreeListItemPanel)) continue;
                    TreeListItemPanel itemComponent = (TreeListItemPanel)component;
                    if (listNum >= start && listNum < end && !itemComponent.isDeflating()) {
                        components.add(itemComponent);
                    }
                    if (!itemComponent.isDeflating()) {
                        ++listNum;
                    }
                    if (listNum >= end) break;
                }
                for (TreeListItemPanel component : components) {
                    TreeListPanel.this.removeItemInputListeners(component);
                    component.getTreeListItem().setSelected(false);
                    this._inflateAnimator.deflate(component);
                }
                TreeListPanel.this.syncSelection();
            } else if ("itemsReplaced".equals(evt.getPropertyName())) {
                boolean animate;
                this._expandAnimator.stop();
                this._inflateAnimator.completeAll();
                this._slideAnimator.complete();
                boolean bl = animate = event != null;
                if (animate) {
                    ArrayList<TreeListItemPanel> oldItemPanels = new ArrayList<TreeListItemPanel>();
                    for (Component component : TreeListPanel.this.getComponents()) {
                        if (!(component instanceof TreeListItemPanel)) continue;
                        TreeListItemPanel itemComponent = (TreeListItemPanel)component;
                        TreeListPanel.this.removeItemInputListeners(itemComponent);
                        itemComponent.getTreeListItem().setSelected(false);
                        oldItemPanels.add(itemComponent);
                    }
                    this._slideAnimator.slide(oldItemPanels, TreeListPanel.this._rootItem.getAsList(), event.isSlideLeft());
                } else {
                    TreeListPanel.this.addAllItems();
                    TreeListPanel.this.repaint();
                }
            }
        }

        private int getInsertIndex(int listIndex) {
            Component[] components = TreeListPanel.this.getComponents();
            int listNum = 0;
            int componentNum = 0;
            for (Component component : components) {
                if (!(component instanceof TreeListItemPanel)) continue;
                TreeListItemPanel itemComponent = (TreeListItemPanel)component;
                if (listNum == listIndex) {
                    if (!itemComponent.isDeflating()) break;
                    ++componentNum;
                    break;
                }
                if (!itemComponent.isDeflating()) {
                    ++listNum;
                }
                ++componentNum;
            }
            return componentNum;
        }
    }

    private class InputListener
    extends MouseAdapter
    implements FocusListener,
    KeyListener {
        private InputListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!TreeListPanel.this.handle(e) && e.isPopupTrigger()) {
                this.showMenu(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!TreeListPanel.this.handle(e)) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                } else if (e.getButton() == 1) {
                    this.leftClicked(e);
                }
            }
        }

        private void leftClicked(MouseEvent e) {
            int index = TreeListPanel.this.getIndex((Component)e.getSource());
            if (index < 0) {
                TreeListPanel.this._selectionModel.clearSelection();
            }
            if (!TreeListPanel.this.hasFocus()) {
                TreeListPanel.this.requestFocus();
            }
        }

        private void showMenu(MouseEvent e) {
            JPopupMenu popup = TreeListMenuFactory.createPopup(Collections.EMPTY_LIST);
            popup.show(e.getComponent(), e.getX(), e.getY());
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.repaintCellFocus();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.repaintCellFocus();
        }

        protected void repaintCellFocus() {
            TreeListPanel.this.repaint();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int s = TreeListPanel.this._selectionModel.getLeadSelectionIndex();
            int componentCount = TreeListPanel.this.getComponentCount() - 1;
            int topIndex = 1;
            int bottomIndex = componentCount - 1;
            Component[] components = TreeListPanel.this.getComponents();
            while (!components[bottomIndex].isVisible()) {
                --bottomIndex;
            }
            boolean updateSelection = true;
            if (s < topIndex) {
                if (componentCount < 1) {
                    return;
                }
            } else {
                switch (e.getKeyCode()) {
                    case 37: {
                        ((TreeListItemPanel)components[s]).getTreeListItem().setExpanded(false);
                        updateSelection = false;
                        break;
                    }
                    case 38: {
                        while (--s > 0 && !components[s].isVisible()) {
                        }
                        break;
                    }
                    case 39: {
                        ((TreeListItemPanel)components[s]).getTreeListItem().setExpanded(true);
                        updateSelection = false;
                        break;
                    }
                    case 40: {
                        while (++s < components.length && !components[s].isVisible()) {
                        }
                        break;
                    }
                    case 33: {
                        int visibleHeight = TreeListPanel.this.getVisibleRect().height;
                        int selectionY = components[s].getLocation().y;
                        int nextY = selectionY - visibleHeight;
                        boolean found = false;
                        for (int i = bottomIndex; i >= topIndex; --i) {
                            Component c = components[i];
                            Point location = c.getLocation();
                            if (!c.isVisible() || location.y > nextY) continue;
                            s = i;
                            found = true;
                            break;
                        }
                        if (found) break;
                        s = topIndex;
                        break;
                    }
                    case 36: {
                        s = topIndex;
                        break;
                    }
                    case 34: {
                        int visibleHeight = TreeListPanel.this.getVisibleRect().height;
                        int selectionY = components[s].getLocation().y;
                        int nextY = selectionY + visibleHeight;
                        boolean found = false;
                        for (int i = topIndex; i <= bottomIndex; ++i) {
                            if (!components[i].isVisible() || components[i].getLocation().y < nextY) continue;
                            s = i;
                            found = true;
                            break;
                        }
                        if (found) break;
                        s = bottomIndex;
                        break;
                    }
                    case 35: {
                        s = bottomIndex;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (s < topIndex) {
                s = bottomIndex;
            }
            if (s > bottomIndex) {
                s = topIndex;
            }
            if (updateSelection) {
                TreeListPanel.this.updateSelection(s, e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class ItemInputListener
    extends MouseAdapter {
        private ItemInputListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!TreeListPanel.this.handle(e) && e.isPopupTrigger()) {
                this.showMenu(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!TreeListPanel.this.handle(e)) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                } else if (e.getButton() == 1) {
                    this.select(e);
                }
            }
        }

        private void select(MouseEvent e) {
            int index = TreeListPanel.this.getIndex((Component)e.getSource());
            if (TreeListPanel.this.isValidIndex(index)) {
                TreeListPanel.this.updateSelection(index, e);
            }
            if (!TreeListPanel.this.hasFocus()) {
                TreeListPanel.this.requestFocus();
            }
        }

        private void showMenu(MouseEvent e) {
            int index = TreeListPanel.this.getIndex((Component)e.getSource());
            if (TreeListPanel.this.isValidIndex(index)) {
                if (!TreeListPanel.this._selectionModel.isSelectedIndex(index)) {
                    TreeListPanel.this._selectionModel.setSelectionInterval(index, index);
                }
                List<TreeListItem> selected = this.getSelectedItems();
                JPopupMenu popup = TreeListMenuFactory.createPopup(selected);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private List<TreeListItem> getSelectedItems() {
            List<TreeListItem> items = TreeListPanel.this._rootItem.getAsList();
            ArrayList<TreeListItem> selected = new ArrayList<TreeListItem>();
            for (TreeListItem item : items) {
                if (!item.isSelected()) continue;
                selected.add(item);
            }
            return selected;
        }
    }
}

