/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.treelist;

import com.paterva.maltego.util.ui.treelist.AbstractTreeListItemPanel;
import com.paterva.maltego.util.ui.treelist.ConstraintUtils;
import com.paterva.maltego.util.ui.treelist.TreeListPanel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Timer;

public class TreeListInflateAnimator {
    private static final int TIMER_DELAY_MS = 8;
    private static final int EXPAND_TIME_MS = 150;
    private final TreeListPanel _treeList;
    private final TimerListener _listener = new TimerListener();
    private final Map<AbstractTreeListItemPanel, Long> _components = new HashMap<AbstractTreeListItemPanel, Long>();
    private Timer _timer;

    TreeListInflateAnimator(TreeListPanel treeList) {
        this._treeList = treeList;
    }

    public void inflate(AbstractTreeListItemPanel component) {
        this.change(component, false);
    }

    public void deflate(AbstractTreeListItemPanel component) {
        this.change(component, true);
    }

    private void change(AbstractTreeListItemPanel component, boolean deflate) {
        if (component.isVisible()) {
            component.setDeflating(deflate);
            this._components.put(component, System.currentTimeMillis());
            if (this._timer == null) {
                this._timer = new Timer(8, this._listener);
                this._timer.setRepeats(true);
                this._timer.start();
            }
            this.update();
        } else if (deflate) {
            this._treeList.remove(component);
        }
    }

    public void completeAll() {
        this.complete(this._components.keySet());
    }

    public void complete(Collection<AbstractTreeListItemPanel> components) {
        if (this._timer != null) {
            for (AbstractTreeListItemPanel component : components) {
                Long startTime = this._components.get(component);
                if (startTime == null) continue;
                this._components.put(component, 0L);
            }
            this.update();
        }
    }

    private void update() {
        long time = System.currentTimeMillis();
        Iterator<Map.Entry<AbstractTreeListItemPanel, Long>> itr = this._components.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<AbstractTreeListItemPanel, Long> entry = itr.next();
            AbstractTreeListItemPanel component = entry.getKey();
            Long startTime = entry.getValue();
            boolean deflating = component.isDeflating();
            if (time > startTime + 150L) {
                itr.remove();
                if (deflating) {
                    this.update(component, 0.0);
                    this._treeList.remove(component);
                    component.setDeflating(false);
                    continue;
                }
                this.update(component, 1.0);
                continue;
            }
            long endTime = startTime + 150L;
            double inflatedness = deflating ? (double)(endTime - time) / 150.0 : (double)(time - startTime) / 150.0;
            this.update(component, inflatedness);
        }
        if (this._components.isEmpty()) {
            this._timer.stop();
            this._timer = null;
        }
        this._treeList.revalidate();
        this._treeList.repaint();
    }

    private void update(AbstractTreeListItemPanel component, double inflatedness) {
        component.setMinimumSize(null);
        component.setMaximumSize(null);
        component.setPreferredSize(null);
        Integer finalSize = component.getPreferredSize().height;
        int height = (int)((double)finalSize.intValue() * inflatedness);
        Dimension minimumSize = component.getMinimumSize();
        minimumSize.height = height;
        component.setMinimumSize(minimumSize);
        Dimension maximumSize = component.getMaximumSize();
        maximumSize.height = height;
        component.setMaximumSize(maximumSize);
        Dimension size = component.getPreferredSize();
        size.height = height;
        component.setPreferredSize(size);
        GridBagConstraints constraints = ConstraintUtils.getConstraints(this._treeList, component);
        ConstraintUtils.updateContraints(this._treeList, component, constraints);
        this._treeList.setSize(0, 0);
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeListInflateAnimator.this.update();
        }
    }
}

