/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.slide;

import com.paterva.maltego.util.ui.Direction;
import com.paterva.maltego.util.ui.slide.SlideWindow;
import com.paterva.maltego.util.ui.slide.SlideWindowContainer;
import com.paterva.maltego.util.ui.slide.SlideWindowSerializer;
import java.awt.Rectangle;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public class DefaultSlideWindowSerializer
extends SlideWindowSerializer {
    private static final String SLIDE_WINDOW_PREFS = "SlideWindow";
    private static final String PREF_DIRECTION = "direction";
    private static final String PREF_X = "x";
    private static final String PREF_Y = "y";
    private static final String PREF_W = "w";
    private static final String PREF_H = "h";
    private static final String PREF_PINNED = "pinned";

    @Override
    public void restore(SlideWindowContainer container) {
        SlideWindow slideWindow = container.getSlideWindow();
        String name = this.getPrefsName(slideWindow);
        Preferences prefs = this.getPreferences(name);
        this.restorePosition(prefs, container);
        this.restorePin(prefs, container);
    }

    @Override
    public void save(SlideWindowContainer container) {
        SlideWindow slideWindow = container.getSlideWindow();
        String name = this.getPrefsName(slideWindow);
        Preferences prefs = this.getPreferences(name);
        this.savePosition(prefs, container);
        this.savePin(prefs, container);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private Preferences getPreferences(String name) {
        Preferences prefs = NbPreferences.forModule(SlideWindowSerializer.class);
        return prefs.node("SlideWindow/" + name);
    }

    private String toString(Direction direction) {
        return direction.name();
    }

    private Direction fromString(String directionStr) {
        return Direction.valueOf(directionStr);
    }

    private String getPrefsName(SlideWindow slideWindow) {
        return slideWindow.getSlideWindowName().replaceAll("\\s", "").toLowerCase();
    }

    private void restorePosition(Preferences prefs, SlideWindowContainer container) {
        SlideWindow slideWindow = container.getSlideWindow();
        Rectangle defaultBounds = slideWindow.getDefaultBounds();
        Direction defaultDirection = slideWindow.getDefaultDirection();
        String directionStr = prefs.get(PREF_DIRECTION, this.toString(defaultDirection));
        int x = prefs.getInt(PREF_X, defaultBounds.x);
        int y = prefs.getInt(PREF_Y, defaultBounds.y);
        int w = prefs.getInt(PREF_W, defaultBounds.width);
        int h = prefs.getInt(PREF_H, defaultBounds.height);
        Rectangle screenBounds = WindowManager.getDefault().getMainWindow().getGraphicsConfiguration().getBounds();
        Direction direction = this.fromString(directionStr);
        switch (direction) {
            case NORTH: {
                y = -w;
                break;
            }
            case SOUTH: {
                y = screenBounds.height;
                break;
            }
            case EAST: {
                x = screenBounds.width;
                break;
            }
            case WEST: {
                x = -h;
            }
        }
        container.setBounds(x, y, w, h);
    }

    private void restorePin(Preferences prefs, SlideWindowContainer container) {
        container.setPinned(prefs.getBoolean(PREF_PINNED, false));
    }

    private void savePosition(Preferences prefs, SlideWindowContainer container) {
        prefs.put(PREF_DIRECTION, this.toString(container.getDirection()));
        prefs.putInt(PREF_X, container.getX());
        prefs.putInt(PREF_Y, container.getY());
        prefs.putInt(PREF_W, container.getWidth());
        prefs.putInt(PREF_H, container.getHeight());
    }

    private void savePin(Preferences prefs, SlideWindowContainer container) {
        prefs.putBoolean(PREF_PINNED, container.isPinned());
    }
}

