/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.paterva.maltego.util.FileExtensionFileFilter;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public abstract class FileController
extends ValidatingController<JFileChooser>
implements WizardDescriptor.ValidatingPanel {
    public static final String SELECTED_FILE = "selectedFile";
    public static final String SELECTED_FILES = "selectedFiles";
    public static final String BROWSE_DIR = "browseDir";
    private final String _fileType;
    private String[] _fileExtensions;
    private final int _dialogType;
    private File _backupFile;
    private File[] _backupFiles;

    public FileController(int dialogType, String fileType, String[] fileExtensions) {
        this.setName("Select File");
        this._dialogType = dialogType;
        this._fileType = fileType;
        this._fileExtensions = fileExtensions;
    }

    public void setFileExtensions(String[] fileExtensions) {
        this._fileExtensions = fileExtensions;
    }

    @Override
    protected String getFirstError(JFileChooser component) {
        return null;
    }

    @Override
    protected JFileChooser createComponent() {
        JFileChooser f = new JFileChooser();
        f.setName(this.getName());
        f.setDialogType(this._dialogType);
        f.setControlButtonsAreShown(false);
        f.setMultiSelectionEnabled(false);
        if (this._dialogType == 1) {
            f.setAcceptAllFileFilterUsed(false);
        }
        if (this._fileExtensions != null && this._fileType != null) {
            f.setFileFilter((FileFilter)new FileExtensionFileFilter(this._fileExtensions, this._fileType));
        }
        f.addActionListener(evt -> this.getDescriptor().doNextClick());
        return f;
    }

    @Override
    public void readSettings(WizardDescriptor settings) {
        File selectedFile = (File)settings.getProperty(SELECTED_FILE);
        String browseDir = (String)settings.getProperty(BROWSE_DIR);
        if (selectedFile != null) {
            ((JFileChooser)this.component()).setSelectedFile(selectedFile);
        } else if (!StringUtilities.isNullOrEmpty((String)browseDir)) {
            ((JFileChooser)this.component()).setCurrentDirectory(new File(browseDir));
        }
    }

    @Override
    public void storeSettings(WizardDescriptor settings) {
        File file = null;
        File[] files = null;
        JFileChooser component = (JFileChooser)this.component();
        boolean isMultiFiles = component.isMultiSelectionEnabled();
        try {
            file = this.getTypedFile(component);
            if (isMultiFiles) {
                files = this.getTypedFiles(component);
            }
            if (this._dialogType == 0) {
                if (!(file != null && file.exists() || (file = component.getSelectedFile()) != null && file.exists())) {
                    file = this._backupFile;
                }
                if (file != null && file.exists()) {
                    this._backupFile = file;
                }
                if (isMultiFiles) {
                    if (files == null && (files = component.getSelectedFiles()) != null) {
                        files = this._backupFiles;
                    }
                    if (files != null) {
                        this._backupFiles = files;
                    }
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        String browseDir = null;
        if (!isMultiFiles) {
            if (file != null) {
                if (this._dialogType == 1 && !file.isDirectory()) {
                    boolean foundMatch = false;
                    for (String extension : this._fileExtensions) {
                        if (!file.getName().endsWith(this.getExtensionWithDot(extension))) continue;
                        foundMatch = true;
                        break;
                    }
                    if (!foundMatch) {
                        FileNameExtensionFilter filter;
                        String[] extensions;
                        boolean extensionApplied = false;
                        FileFilter fileFilter = component.getFileFilter();
                        if (fileFilter instanceof FileExtensionFileFilter) {
                            FileExtensionFileFilter filter2 = (FileExtensionFileFilter)fileFilter;
                            extensions = filter2.getExtensions();
                            if (extensions.length > 0) {
                                file = new File(file.getPath() + this.getExtensionWithDot(extensions[0]));
                                extensionApplied = true;
                            }
                        } else if (fileFilter instanceof FileNameExtensionFilter && (extensions = (filter = (FileNameExtensionFilter)fileFilter).getExtensions()).length > 0) {
                            file = new File(file.getPath() + this.getExtensionWithDot(extensions[0]));
                            extensionApplied = true;
                        }
                        if (!extensionApplied) {
                            file = new File(file.getPath() + this.getExtensionWithDot(this._fileExtensions[0]));
                        }
                    }
                }
                if (file.isDirectory()) {
                    browseDir = file.getAbsolutePath();
                    file = null;
                } else {
                    browseDir = file.getAbsoluteFile().getParent();
                }
            }
        } else if (files != null && files.length > 0) {
            browseDir = files[0].getAbsoluteFile().getParent();
        }
        settings.putProperty(SELECTED_FILE, (Object)file);
        settings.putProperty(SELECTED_FILES, (Object)files);
        settings.putProperty(BROWSE_DIR, (Object)browseDir);
        if (browseDir != null) {
            NbPreferences.root().put(BROWSE_DIR, browseDir);
        }
    }

    private String getExtensionWithDot(String extension) {
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        return extension;
    }

    private File getTypedFile(JFileChooser component) throws Exception {
        File file = null;
        Method getFileName = component.getUI().getClass().getDeclaredMethod("getFileName", new Class[0]);
        String fn = (String)getFileName.invoke((Object)component.getUI(), new Object[0]);
        if (fn != null && !(file = new File(fn)).isAbsolute()) {
            file = new File(component.getCurrentDirectory(), fn);
        }
        return file;
    }

    private File[] getTypedFiles(JFileChooser component) throws Exception {
        File[] files = null;
        Method getFileName = component.getUI().getClass().getDeclaredMethod("getFileName", new Class[0]);
        String fn = (String)getFileName.invoke((Object)component.getUI(), new Object[0]);
        if (fn != null) {
            ArrayList<File> list = new ArrayList<File>();
            for (String fileSplit : fn.split("\"")) {
                if (fileSplit.trim().isEmpty()) continue;
                File file = new File(fileSplit);
                if (!file.isAbsolute()) {
                    file = new File(component.getCurrentDirectory(), fileSplit);
                }
                if (!file.exists()) continue;
                list.add(file);
            }
            files = list.toArray(new File[list.size()]);
        }
        return files;
    }

    protected File getSelectedFile() {
        this.storeSettings(this.getDescriptor());
        return (File)this.getDescriptor().getProperty(SELECTED_FILE);
    }

    protected File[] getSelectedFiles() {
        this.storeSettings(this.getDescriptor());
        return (File[])this.getDescriptor().getProperty(SELECTED_FILES);
    }

    protected File[] getOneOrMoreSelectedFiles() {
        File[] files = this.getSelectedFiles();
        if (files == null || files.length == 0) {
            File[] fileArray;
            File file = this.getSelectedFile();
            if (file != null) {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = file;
            } else {
                fileArray = new File[]{};
            }
            files = fileArray;
        }
        return files;
    }
}

