/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Insets;

public class HtmlInsets {
    public static final int TYPE_UNDEFINED = 0;
    public static final int TYPE_PIXELS = 1;
    public static final int TYPE_AUTO = 2;
    public static final int TYPE_PERCENT = 3;
    public int top;
    public int bottom;
    public int left;
    public int right;
    public int topType;
    public int bottomType;
    public int leftType;
    public int rightType;

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getRight() {
        return this.right;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public int getTopType() {
        return this.topType;
    }

    public void setTopType(int topType) {
        this.topType = topType;
    }

    public int getBottomType() {
        return this.bottomType;
    }

    public void setBottomType(int bottomType) {
        this.bottomType = bottomType;
    }

    public int getLeftType() {
        return this.leftType;
    }

    public void setLeftType(int leftType) {
        this.leftType = leftType;
    }

    public int getRightType() {
        return this.rightType;
    }

    public void setRightType(int rightType) {
        this.rightType = rightType;
    }

    public Insets getAWTInsets(int defaultTop, int defaultLeft, int defaultBottom, int defaultRight, int availWidth, int availHeight, int autoX, int autoY) {
        int top = HtmlInsets.getInsetPixels(this.top, this.topType, defaultTop, availHeight, autoY);
        int left = HtmlInsets.getInsetPixels(this.left, this.leftType, defaultLeft, availWidth, autoX);
        int bottom = HtmlInsets.getInsetPixels(this.bottom, this.bottomType, defaultBottom, availHeight, autoY);
        int right = HtmlInsets.getInsetPixels(this.right, this.rightType, defaultRight, availWidth, autoX);
        return new Insets(top, left, bottom, right);
    }

    public Insets getSimpleAWTInsets(int availWidth, int availHeight) {
        int top = HtmlInsets.getInsetPixels(this.top, this.topType, 0, availHeight, 0);
        int left = HtmlInsets.getInsetPixels(this.left, this.leftType, 0, availWidth, 0);
        int bottom = HtmlInsets.getInsetPixels(this.bottom, this.bottomType, 0, availHeight, 0);
        int right = HtmlInsets.getInsetPixels(this.right, this.rightType, 0, availWidth, 0);
        return new Insets(top, left, bottom, right);
    }

    private static int getInsetPixels(int value, int type, int defaultValue, int availSize, int autoValue) {
        if (type == 1) {
            return value;
        }
        if (type == 0) {
            return defaultValue;
        }
        if (type == 2) {
            return autoValue;
        }
        if (type == 3) {
            return availSize * value / 100;
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return "[" + this.top + "," + this.left + "," + this.bottom + "," + this.right + "]";
    }
}

