/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.guided.tour.ui;

import com.maltego.guided.tour.TourStep;
import com.maltego.guided.tour.ui.GuidedTourUtil;
import com.maltego.guided.tour.ui.StepNavigationPanel;
import com.maltego.guided.tour.ui.TitlePanel;
import com.maltego.guided.tour.ui.TourDialog;
import com.maltego.guided.tour.ui.TourDialogPresenter;
import com.maltego.guided.tour.ui.TutorialDefaults;
import com.paterva.maltego.util.MaltegoUrl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.function.Consumer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class TransformsDialog
extends TourDialog {
    private TopComponent editorTC;
    private TourStep tourStep = TourStep.DEFAULT;
    private StepNavigationPanel navigationPanel;
    private TitlePanel titlePanel;

    public TransformsDialog(Frame frame) {
        super(frame);
        this.setMinimumSize(new Dimension(370, 0));
        this.initComponents();
        this.setEditorTC();
        this.adjustLocation();
        this.adjustShape();
        this.getContentPane().setBackground(TutorialDefaults.COLOR_STEP_BACKGROUND);
    }

    @Override
    protected Point getRelativeLocation() {
        int x = -90;
        int y = 90;
        if (this.editorTC.getWidth() < 500) {
            x -= 125;
        }
        if (this.editorTC.getHeight() < 500) {
            y -= 70;
        }
        return new Point(x, y);
    }

    @Override
    public void setTourStep(TourStep tourStep) {
        this.tourStep = tourStep;
        this.titlePanel.setTourStep(tourStep);
        this.navigationPanel.setTourStep(tourStep);
    }

    private void setEditorTC() {
        Mode editorMode = WindowManager.getDefault().findMode("editor");
        this.editorTC = editorMode.getSelectedTopComponent();
        this.setLocationOnComponent((Component)this.editorTC);
    }

    private void adjustShape() {
        Area rectangle = new Area(new Rectangle(0, 0, this.getWidth() - 10, this.getHeight()));
        Area triangle = new Area(new Polygon(new int[]{this.getWidth(), this.getWidth() - 10, this.getWidth() - 10}, new int[]{60, 50, 70}, 3));
        rectangle.add(triangle);
        this.setShape(rectangle);
    }

    private void initComponents() {
        this.titlePanel = new TitlePanel();
        JLabel animationLabel = new JLabel();
        JTextArea contentTextArea = new JTextArea();
        this.navigationPanel = new StepNavigationPanel();
        this.setDefaultCloseOperation(2);
        this.titlePanel.setTitle(NbBundle.getMessage(TransformsDialog.class, (String)"TransformsDialog.titlePanel.title"));
        animationLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/maltego/guided/tour/ui/anim_transforms.gif")));
        contentTextArea.setEditable(false);
        contentTextArea.setColumns(20);
        contentTextArea.setFont(contentTextArea.getFont().deriveFont((float)contentTextArea.getFont().getSize() + 3.0f));
        contentTextArea.setLineWrap(true);
        contentTextArea.setRows(8);
        contentTextArea.setText(NbBundle.getMessage(TransformsDialog.class, (String)"TransformsDialog.contentTextArea.text"));
        contentTextArea.setWrapStyleWord(true);
        contentTextArea.setBorder(null);
        contentTextArea.setDisabledTextColor(TutorialDefaults.COLOR_TEXT);
        contentTextArea.setEnabled(false);
        contentTextArea.setOpaque(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(animationLabel, -1, -1, Short.MAX_VALUE).addComponent(this.titlePanel, -1, -1, Short.MAX_VALUE).addComponent(contentTextArea).addComponent(this.navigationPanel, -2, 0, Short.MAX_VALUE)).addContainerGap(25, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.titlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(animationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(contentTextArea, -2, -1, -2).addGap(32, 32, 32).addComponent(this.navigationPanel, -2, -1, -2).addContainerGap(15, Short.MAX_VALUE)));
        this.pack();
    }

    public static class Presenter
    extends TourDialogPresenter<TransformsDialog> {
        @Override
        protected TransformsDialog createTourDialog(Frame frame) {
            return new TransformsDialog(frame);
        }

        @Override
        public Consumer<Graphics2D> getPainter() {
            Mode editorMode = WindowManager.getDefault().findMode("editor");
            TopComponent selectedTopComponent = editorMode.getSelectedTopComponent();
            return GuidedTourUtil.createTransformsPainter(selectedTopComponent);
        }

        @Override
        public String learnMoreLink() {
            return MaltegoUrl.getCurrent().getGotoOnboardingTransformMenu();
        }
    }
}

