/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config.jre;

import com.paterva.maltego.java.config.jre.ExecutionResults;
import com.paterva.maltego.java.config.jre.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;

public class SystemUtils {
    public static final long MAX_EXECUTION_TIME = 600000L;
    public static final int MAX_DELAY = 50;
    public static final int INITIAL_DELAY = 5;
    public static final int DELTA_DELAY = 5;

    public static ExecutionResults executeCommand(boolean silent, String ... command) throws IOException {
        String commandString = StringUtils.asString(command, " ");
        File workingDirectory = new File(".");
        if (!silent) {
            System.out.println("executing: " + commandString + ", in: " + workingDirectory);
        }
        StringBuilder processStdOut = new StringBuilder();
        StringBuilder processStdErr = new StringBuilder();
        int errorLevel = Integer.MAX_VALUE;
        ProcessBuilder builder = new ProcessBuilder(command).directory(workingDirectory);
        Process process = builder.start();
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 600000L;
        boolean doRun = true;
        long delay = 5L;
        while (doRun && System.currentTimeMillis() < endTime) {
            String line;
            BufferedReader reader;
            try {
                Thread.sleep(delay);
                if (delay < 50L) {
                    delay += 5L;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                errorLevel = process.exitValue();
                doRun = false;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
            String string = StringUtils.readStream(process.getInputStream());
            if (string.length() > 0) {
                reader = new BufferedReader(new StringReader(string));
                line = reader.readLine();
                while (line != null) {
                    endTime = System.currentTimeMillis() + 600000L;
                    line = reader.readLine();
                }
                processStdOut.append(string);
            }
            if ((string = StringUtils.readStream(process.getErrorStream())).length() <= 0) continue;
            reader = new BufferedReader(new StringReader(string));
            line = reader.readLine();
            while (line != null) {
                endTime = System.currentTimeMillis() + 600000L;
                line = reader.readLine();
            }
            processStdErr.append(string);
        }
        if (!silent) {
            System.out.println(doRun ? " killed by timeout" : " result: " + errorLevel);
        }
        process.destroy();
        if (!silent) {
            System.out.println(" command execution finished");
        }
        return new ExecutionResults(errorLevel, processStdOut.toString(), processStdErr.toString());
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static boolean isWindows2() {
        String osOverride = System.getProperty("os.name.override");
        if (osOverride != null) {
            return osOverride.toLowerCase().contains("windows");
        }
        return SystemUtils.isWindows();
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("mac") || os.contains("os x");
    }

    public static boolean isUnix() {
        return !SystemUtils.isWindows() && !SystemUtils.isMac();
    }
}

